// $Id$

//=============================================================================
/**
 *  @file    HSTerminalManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSTERMINALMANAGER_H
#define HSTERMINALMANAGER_H

#include "jyugem/gem/JGTerminalManager.h"

/*
 *
 */
class HSTerminalManager: public JGTerminalManager
{
public:
    HSTerminalManager();
    ~HSTerminalManager();

    virtual int init(void * argv = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int display(int tid, int termid, const string& text);    // send S10F3
    int display(int tid, int termid, vector<string>& texts); // send S10F5

    static HSTerminalManager * instance();

protected:
    BS2Message * makeBlock(int termid, const string& text);     // make S10F3
    BS2Message * makeBlock(int termid, vector<string>& texts);  // make S10F5

};


#endif
