// $Id$

//=============================================================================
/**
 *  @file    or_expression.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#ifndef JYUGEM_BEE_OR_EXPRESSION_H
#define JYUGEM_BEE_OR_EXPRESSION_H

#include "sequencer.h"

namespace jyugem { namespace bee
{

temptate<class EXP, class T>
struct BEE_Export or_expression : public expression<EXP, T>
{
    typedef sequencer<T>       seq_type;
    typedef expression<EXP, T> expression_base;

    or_expression(std::vector<step *>& nodes) : expression_base()
    {
        m_act = nodes;
    }
    or_expression(seq_type * sqcr, const string& cond,
                  std::vector<step *>& nodes) : expression_base(sqcr, cond)
    {
        m_act = nodes;
    }
    virtual ~or_expression() {}

    virtual int evaluate(T * context)
    {
        while (1)  // parallel
        {
            size_t i;
            for (i = 0; i < m_act.size(); i++)
            {
                BEEAssert(m_act[i] != null);
                int result = m_act[i]->evaluate(context);
                if (result == 0)
                {
                    return 0;
                }
            }
        }
        return -1;
    }
};


} } // *namespace*

#endif
