// $Id$

//=============================================================================
/**
 *  @file    vfei.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JYUGEM_CELL_VFEI_H
#define JYUGEM_CELL_VFEI_H

#include <fstream>
#include <iostream>
#include <string>
#include <algorithm>
#include <strstream>
#include <vector>
#include <stack>
#include <map>

namespace jyugem { namespace cell
{

#define null   (0)

#ifndef SFCODE
#define SFCODE(S,F)  (((S) << 8) + (F))
#endif

////////////////////////////////////////////////////////////////////////////////
// VFEI COMMANDS
////////////////////////////////////////////////////////////////////////////////
// Command Name         Stream/Function
//---------------------+---------------+----------------------------------------
// ABORT                S2F49           Abort Propcess
// ALARM_REPORT         S5F1            Alarm Report
// ALARM_SETUP          S5F3            Enable/Disable Alarm Reporting
// CMD_ACK              SxFx            Command Acknowledgment
// DISPLAY_MSG          S10F3           Display Message on Equipment
// EVENT_REPORT         S6F11           Event Occurs on Equipment
// EVENT_SETUP          S2F37           Enable/Disable Data Collection by Event
// INITIALIZE           SxFx            Initialize Logical Communications
// MACH_CMD             S2F49           Remote Equipment Command
// MOVE                 S2F49           Request Transfer of a Transfer Group
// PAUSE                S2F49           Pause Processing
// RES_ACTIVATE         S15F21          Resource Activate
// RES_DEACTIVATE       S15F21          Resource Deactivate
// RES_DELETE           S7F17           Resource Delete
// RES_LIST             S7F19           Resource List
// RES_QUERY            S7F5            Resource Query
// RES_REQUEST          S7F1            Resource Transfer Request
// RES_TRANSFER         S7F3            Resource Transfer
// RESTART              S2F49           Restart Logical Communications
// RESUME               S2F49           Resume Processing
// SET_PARAM            S15F21          Set Resource Parameters
// START                S2F49           Start Processing
// STATUS_LIST          S1F11           Status Variable List
// STATUS_QUERY         S1F3            Query for Current Status
// TRACE_REPORT         S6F1            Data Collection Based On Time
// TRACE_SETUP          S2F23           Enable Data Collection on Time
//

enum
{
  VFEI_UNKNOWN        = 0,
  VFEI_ABORT          = 1,
  VFEI_ALARM_REPORT   = 2,
  VFEI_ALARM_SETUP    = 3,
  VFEI_CMD_ACK        = 4,
  VFEI_DISPLAY_MSG    = 5,
  VFEI_EVENT_REPORT   = 6,
  VFEI_EVENT_SETUP    = 7,
  VFEI_INITIALIZE     = 8,
  VFEI_MACH_CMD       = 9,
  VFEI_MOVE           = 10,
  VFEI_PAUSE          = 11,
  VFEI_RES_ACTIVATE   = 12,
  VFEI_RES_DEACTIVATE = 13,
  VFEI_RES_DELETE     = 14,
  VFEI_RES_LIST       = 15,
  VFEI_RES_QUERY      = 16,
  VFEI_RES_REQUEST    = 17,
  VFEI_RES_TRANSFER   = 18,
  VFEI_RESTART        = 19,
  VFEI_RESUME         = 20,
  VFEI_SET_PARAM      = 21,
  VFEI_START          = 22,
  VFEI_STATUS_LIST    = 23,
  VFEI_STATUS_QUERY   = 24,
  VFEI_TRACE_REPORT   = 25,
  VFEI_TRACE_SETUP    = 26,
  VFEI_MAX_COMMAND
};

enum { UNKNOWN = 0, EtoH = 1, HtoE = 2, BOTH = 3 };

} }  // *jyugem::cell*

#endif  // JYUGEM_CELL_VFEI_H
