// $Id: JGBitVector.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGBitVector.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGBITVECTOR_H
#define JGBITVECTOR_H

#include "jyugem/gem/gembase.h"

#define BITMAP_BYTES(x)    ((((x) + 31) / 32) * sizeof(UINT))

//-----------------------------------------------------------------------------
// Bit Control.
//-----------------------------------------------------------------------------
class BEE_Export JGBitVector
{
public:
    JGBitVector() : m_delete(true), m_size(0), m_table(NULL) {}
    JGBitVector(size_t size);
    JGBitVector(size_t size, UINT * bitbuf, bool del = false);  // for mmap
    JGBitVector(const JGBitVector& rhs) { copy(rhs); }
    ~JGBitVector();

    JGBitVector& operator=(const JGBitVector& rhs) {
            if (this == &rhs)
                return *this;
            copy(rhs);
            return *this;
        }
    size_t size()       { return m_size; }
    UINT * bits()       { return m_table; }
    bool get(int idx);  // idx = [0, size)
    bool set(int idx)   { return this->put(idx, true); }
    bool reset(int idx) { return this->put(idx, false); }
    void clear();
    int  firstOff();

    static UINT MaskTable[32];

protected:
    void copy(const JGBitVector& rhs);
    bool put(int idx, bool cond);

protected:
    bool   m_delete;
    size_t m_size;
    UINT * m_table;
};


#endif  // JGBITVECTOR_H
