// $Id: JGDefineTrigger.h,v 1.4 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDefineTrigger.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEFINETRIGGER_H
#define JGDEFINETRIGGER_H

//-----------------------------------------------------------------------------
// Definition of Trigger Category (=id)
//
#define TRID_ALARM                  _TX("AlarmState")
#define TRID_COMMUNICATION          _TX("CommunicationsState")
#define TRID_CONTROL                _TX("ControlState")
#define TRID_OPERATOR_CMD           _TX("OperatorCommand")
#define TRID_PROCESS                _TX("ProcessState")
#define TRID_ECV                    _TX("EquipmentConst")
#define TRID_RECIPE_EXEC            _TX("RecipeExec")
#define TRID_RECIPE                 _TX("RecipeState")
#define TRID_MSG_RECOGNITION        _TX("MessageRecognition")
#define TRID_TERMINAL               _TX("TerminalMessage")
#define TRID_MATERIAL_MOVED         _TX("MaterialMoved")

//-----------------------------------------------------------------------------
// Definition of Trigger Name
//
#define TRG_UNKNOWN                 _TX("UNKNOWN")
#define TRG_DISABLE                 _TX("DISABLE")
#define TRG_ENABLE                  _TX("ENABLE")
#define TRG_OFFLINE                 _TX("OFFLINE")
#define TRG_ONLINE_LOCAL            _TX("ONLINE_LOCAL")
#define TRG_ONLINE_REMOTE           _TX("ONLINE_REMOTE")
#define TRG_OPERATOR_COMMAND        _TX("OPERATOR_COMMAND")
#define TRG_INIT                    _TX("INIT")
#define TRG_IDLE                    _TX("IDLE")
#define TRG_SETUP                   _TX("SETUP")
#define TRG_READY                   _TX("READY")
#define TRG_EXECUTING               _TX("EXECUTING")
#define TRG_PAUSE                   _TX("PAUSE")
#define TRG_COMPLETE                _TX("COMPLETE")
#define TRG_ALARM_CLEAR             _TX("ALARM_CLEAR")
#define TRG_ALARM_SET               _TX("ALARM_SET")
#define TRG_EQUIPMENT_CONSTANT      _TX("EQUIPMENT_CONSTANT")
#define TRG_PP_SELECT               _TX("PP-SELECT")
#define TRG_CREATE                  _TX("CREATE")
#define TRG_EDIT                    _TX("EDIT")
#define TRG_DELETE                  _TX("DELETE")
#define TRG_PURGE                   _TX("PURGE")
#define TRG_MESSAGE_RECOGNITION     _TX("MESSAGE_RECOGNITION")
#define TRG_TERMINAL_MESSAGE        _TX("TERMINAL_MESSAGE")
#define TRG_TRANSIT_ZONE            _TX("TRANSIT_LIMIT_ZONE")
#define TRG_MATERIAL_TRANSFER       _TX("MATERIAL_TRANSFER")
#define TRG_MATERIAL_OCCUPIED       _TX("OCCUPIED")
#define TRG_MATERIAL_UNOCCUPIED     _TX("UNOCCUPIED")
#define TRG_CONTROL_REMOTE          _TX("REMOTE")
#define TRG_CONTROL_LOCAL           _TX("LOCAL")

#endif
