// $Id: JGEnumSub.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEnumSub.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGENUMSUB_H
#define JGENUMSUB_H

#include "jyugem/gem/JGTriggerInfo.h"

class JGObserver;


//-----------------------------------------------------------------------------
// Enumerate device access of class
//
class JGEnumSubBase : public JGTriggerSubject
{
public:
    JGEnumSubBase() : JGTriggerSubject() {}
    JGEnumSubBase(const JGTriggerSubject& rhs) : JGTriggerSubject(rhs) {}
    virtual ~JGEnumSubBase() {}

    JGEnumSubBase& operator=(const JGEnumSubBase& rhs);
    virtual JGTriggerInfo * factory();

    int parse();
    int range() { return m_enumNames.size(); }
    string& enumerate(int num) {
            return (num < (int)m_enumNames.size()) ? m_enumNames[num] :
                                                JGTriggerSubject::_NilString;
        }
    int convert(const string& token) {
            for (size_t i = 0; i < m_enumNames.size(); i++) {
                if (m_enumNames[i] == token)
                    return i;
            }
            return -1;
        }
//
protected:
    vector<string> m_enumNames;     // Event Names
};


//--------------------------------------
typedef JGTriggerInfoTempl<JGEnumSubBase> JGTrigEnum;

class JGEnumSub : public JGTrigEnum
{
public:
    JGEnumSub(JGEnumSubBase * base): JGTrigEnum(base) {}
    virtual ~JGEnumSub() {}

    virtual int init();
    virtual int changed();

    string& enumerate(int num) { return m_subject->enumerate(num); }
    int convert(const string& token) { return m_subject->convert(token); }
};

//-----------------------------------------------------------------------------
// Enumerate with parameter device access of class
//
class JGEnumParmSubBase : public JGEnumSubBase
{
public:
    JGEnumParmSubBase(): JGEnumSubBase(), m_relation(NULL) {}
    JGEnumParmSubBase(const JGTriggerSubject& rhs)
            : JGEnumSubBase(rhs), m_relation(NULL) {}
    virtual ~JGEnumParmSubBase() {}

    JGEnumParmSubBase& operator=(const JGEnumParmSubBase& rhs);
    virtual JGTriggerInfo * factory();

    JGVariable * relation()         { return m_relation; }
    void relation(JGVariable * var) { m_relation = var; }

protected:
    JGVariable * m_relation;        // Relational variable
};

//-------------------------------------
typedef JGTriggerInfoTempl<JGEnumParmSubBase>  JGTrigEnumParm;

class JGEnumParmSub : public JGTrigEnumParm
{
public:
    JGEnumParmSub(JGEnumParmSubBase * base) : JGTrigEnumParm(base) {}
    virtual ~JGEnumParmSub() {}

    virtual int init();
    virtual int changed();

    JGVariable * relation()         { return m_subject->relation(); }
    void relation(JGVariable * var) { m_subject->relation(var); }

    string& enumerate(int num) { return m_subject->enumerate(num); }
    int convert(const string& token) { return m_subject->convert(token); }
};


#endif  /* JGENUMSUB_H */
