// $Id: JGIODevice.h,v 1.10 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGIODevice.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGIODEVICE_H
#define JGIODEVICE_H

#include "jyugem/gem/gembase.h"

class JGVariable;
class JGTriggerInfo;
class JGIODevManager;
class JGSubSystem;

//
// Define I/O device
//
class JGIODevice
{
public:
    JGIODevice(): m_interlock(""), m_timeEnable(false), m_algorithm(""),
                  m_reset(false), m_baseval(0), m_deltaval(0),
                  m_subject(NULL), m_subsystem(NULL) {}
    JGIODevice(const JGIODevice& rhs);
    virtual ~JGIODevice() {}

    JGIODevice& operator=(const JGIODevice& rhs);

    JGTriggerInfo * subject()         { return m_subject; }
    void subject(JGTriggerInfo * sub) { m_subject = sub; }
    JGSubSystem * subsystem()         { return m_subsystem; }
    void subsystem(JGSubSystem * sys) { m_subsystem = sys; }

    void  variable(JGVariable * var);
    const ACE_Time_Value& interval() const { return m_interval_tv; }
    const ACE_Time_Value& access() const   { return m_access_tv; }
    void  interval(ACE_Time_Value& tv)     { m_interval_tv = tv; }
    void  access(ACE_Time_Value& tv)       { m_access_tv = tv; }
    const string& interlock() const { return m_interlock; }
    const string& algorithm() const { return m_algorithm; }
    bool  enabled() const           { return m_enabled; }
    void  enabled(bool sw)          { m_enabled = sw; }
    bool  timeEnable() const        { return m_timeEnable; }
    void  timeEnable(bool sw)       { m_timeEnable = sw; }
    void  deltaval(JGvalue& val)    { m_deltaval = val; }
    const JGvalue& deltaval() const { return m_deltaval; }
    void  reset(bool tf)            { m_reset = tf; }
    bool  reset() const             { return m_reset; }
    void manager(JGIODevManager * mngr) { m_manager = mngr; }

    virtual  int sense();

private:
    void copy(const JGIODevice& rhs);

protected:
    ACE_Time_Value m_interval_tv;
    ACE_Time_Value m_access_tv;
    string  m_interlock;
    bool    m_enabled;
    bool    m_timeEnable;
    string  m_algorithm;
    bool    m_reset;
    JGvalue m_baseval;    // register reset value
    JGvalue m_deltaval;
    //
    JGvalue m_maxval;
    JGvalue m_minval;
    JGvalue m_initval;
    string  m_units;
    //
    JGVariable *     m_var;
    JGTriggerInfo *  m_subject;
    JGIODevManager * m_manager;
    JGSubSystem *    m_subsystem;
};

typedef map<JGid, JGIODevice *, id_less, allocator<JGIODevice *> >
        JGIODeviceTable;
typedef map<string, JGIODevice *, str_less, allocator<JGIODevice *> >
        JGIODeviceMap;
typedef map<JGid, JGIODevice *, id_less, allocator<JGIODevice *> > JGSacMap;
typedef JGIODeviceTable::value_type  JGIODevicePair;
typedef JGIODeviceMap::value_type    JGIONamePair;
typedef JGSacMap::value_type         JGSacPair;
typedef vector<JGIODevice *>         JGIODevices;
typedef list<JGIODevice *>           JGIODeviceList;

#endif
