// $Id: JGProcess.h,v 1.2 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGProcess.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGPROCESS_H
#define JGPROCESS_H

#include "jyugem/gem/JGManager.h"

#define TRIGGER_INITIALIED _TX("INITIALIED")
#define TRIGGER_SETUP      _TX("SETUP")
#define TRIGGER_CANCEL     _TX("CANCEL")
#define TRIGGER_START      _TX("START")
#define TRIGGER_COMPLETE   _TX("COMPLETE")
#define TRIGGER_STOP       _TX("STOP")
#define TRIGGER_PAUSE      _TX("PAUSE")
#define TRIGGER_RESUME     _TX("RESUME")
#define TRIGGER_ABORT      _TX("ABORT")
#define TRIGGER_SELECT     _TX("PP-SELECT")

class JGProcessManager;
class JGProcessJob;
class JGSubSystem;

/*
 * Process Manager Class
 */
class BEE_Export JGProcess : public JGManager
{
    friend class JGProcessState;
    friend class JGProcessManager;

public:
    JGProcess(int id, const string& name);
    virtual ~JGProcess() {}

    virtual int init(void * argv = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int rcmd_svc(JGService * trigger);

    virtual int update(void * current);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);
    virtual int notify(JGService * rcmd);

    int  procNumber() { return m_procid; }
    bool isActive();
    int  enable(const string& trigName);
    BYTE getState();
    BYTE getPrevState();

private:

private:
    int m_procid;
    JGSubSystem *  m_subsys;        // Process Sub-systems (Chamber)
    JGProcessJob * m_job;

    JGVariable * m_curProcStatus;
    JGVariable * m_prevProcStatus;
    JGVariable * m_remoteCommand;
    JGVariable * m_ppname;
    string m_savedState;
    BYTE   m_prev;

    JGProcessState * m_procState;            // State Model
};

#endif
