// $Id$

//=============================================================================
/**
 *  @file    JGRCmdManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGRCMDMANAGER_H
#define JGRCMDMANAGER_H

#include "jyugem/gem/JGManager.h"
#include "jyugem/gem/JGRemoteCmd.h"


/*
 * Recipe Manager Class
 */
class JGRCmdManager: public JGManager
{
public:
    JGRCmdManager();
    ~JGRCmdManager();

    virtual int init(void * argv = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    JGRemoteCmd * find(const JGid& rcmd);
    JGRemoteCmd * find(const string& cmdName);
    JGRemoteCmd * findBySvc(const string& svcName);
    JGRemoteCmd::Param * param(const string& cpname);
    JGRemoteCmd::Param * paramBySvc(const string& svcName);
    int add(JGRemoteCmd * rcmd);
    int addParam(JGRemoteCmd::Param * param);

    static JGRCmdManager * instance();

protected:
    RemoteCmdTable m_rcmds;
    RCmdMap m_cmdnames;
    RCmdMap m_svcmds;
    RCmdParamMap m_cpnames;
    RCmdParamMap m_svcpnames;
};


#endif
