// $Id: JGReport.h,v 1.3 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGReport.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGREPORT_H
#define JGREPORT_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGNameInfo.h"
#include "jyugem/gem/JGVariable.h"

class BS2Item;

// Define an object to hold configure data
class BEE_Export JGReport : public JGNameInfo
{
public:
    JGReport() : JGNameInfo() {}
    JGReport(JGid& rptid, string& rptname)
            : JGNameInfo(rptname.c_str(), rptid) {}
    virtual ~JGReport() {}
    virtual void  printOn(string& buf, int mode = 0);

    JGReport& operator=(const JGReport& rhs);
    void insert(JGVariable * var) { m_vids.push_back(var); }
    int  erase(JGVariable * var);
    bool exist(JGid& vid);

    JGid& rptid()               { return m_id; }
    void  rptid(const JGid& id) { m_id = id; }
    JGVariables& vids()   { return m_vids; }
    void clearVariables() { m_vids.clear(); }

    BS2Item * create(void * arg = NULL);     // for S6F11
    BS2Item * makeVList(void * arg = NULL);  // for S6F11
    BS2Item * definedReports();              // for S2F33

    size_t size() { return m_vids.size(); }
    JGVariable * variable(size_t pos)
    {
        if (pos >= m_vids.size())
        {
            return NULL;
        }
        return m_vids[pos];
    }
//
private:
    void copy(const JGReport& rhs);

//
protected:
    //
    JGVariables m_vids;

};

//
// Define an object to hold report data
//
class JGRptData
{
public:
    JGRptData() : m_rptid(0), m_vid(0), m_seqnum(0) { }
    JGRptData(JGid& rptid, JGid& vid, int seqnum)
        : m_rptid(rptid), m_vid(vid), m_seqnum(seqnum) { }

    JGid& rptid() { return m_rptid; }
    JGid& vid()   { return m_vid; }
    void rptid(const JGid& id) { m_rptid = id; }
    void vid(const JGid& id)   { m_vid = id; }

protected:
    JGid m_rptid;
    JGid m_vid;
    int  m_seqnum;

};

typedef map<JGid, JGReport, id_less, allocator<JGReport> > JGReportTable;
typedef JGReportTable::value_type  JGReportPair;
typedef vector<JGReport>   JGReportArray;
typedef vector<JGReport *> JGReports;
typedef list<JGReport *>   JGReportList;

#endif  /* JGREPORT_H */
