// $Id: JGSpoolManager.h,v 1.1 2003/02/09 16:16:13 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGSpoolManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSPOOLMANAGER_H
#define JGSPOOLMANAGER_H

#include "jyugem/gem/JGManager.h"
#include "jyugem/gem/JGSpoolDB.h"
#include "jyugem/gem/JGBitVector.h"
#include "BS2TimeValue.h"

#define TRIGGER_NOT_COMMUNICATING  _TX("NOT_COMMUNICATING")
#define TRIGGER_WAIT_DELAY         _TX("WAIT_DELAY")
#define TRIGGER_FULL               _TX("AREA_FULL")
#define TRIGGER_EMPTY              _TX("AREA_EMPTY")
#define TRIGGER_PURGE              _TX("PURGE")
#define TRIGGER_S7F23              _TX("S7F23")
#define TRIGGER_S6F23              _TX("S6F23")
#define TRIGGER_MAX_TRANSMIT       _TX("MAX_SPOOL_TRANSMIT")
#define TRIGGER_COMM_FAILURE       _TX("COMMUNICATION_FAILURE")
#define TRIGGER_POWER_OFF          _TX("POWER_OFF")
#define TRIGGER_POWER_ON           _TX("POWER_ON")

class JGVariable;

// function macros
#define IS_SPOOL_NUMBER(x)     ((((x) & 1) == 1) && (STREAMCODE(x) != 1))


/*
 *  Spooling Manager Class
 */
class BEE_Export JGSpoolManager : public JGManager
{
public:
    enum { NOT_SPOOL = 0, SPOOL };

    friend class JGSpoolState;

public:
    JGSpoolManager();
    virtual ~JGSpoolManager() {}

    virtual int init(void * param = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int  initSpool();
    int  startSpool() { return this->JGManager::notify(TRIGGER_NOT_COMMUNICATING); }
    int  purgeSpool() { return this->JGManager::notify(TRIGGER_PURGE); }
    int  stopSpool()  { // An end of spool depend on purging or transimitting.
            this->setEnabled(false);  return BEE_SUCCESS;
        }
    int  stopTransmit() { return this->JGManager::notify(TRIGGER_COMM_FAILURE); }
    bool isFull()       {return m_spooldb.full(); } // Inquire spool area full
    bool isActive();
    bool isEnabled();
    size_t actualCount();
    size_t totalCount();

    int  input(BS2Message * msg);
    BS2Message * output();
    int  entry(int sfnum);
    int  release(int sfnum);
    bool status(int sfnum);
    void clear();  // Clear all files in "$root/spool" directory
    void dump() const;

    BS2Message * make_s6f23();

    static JGSpoolManager * instance();

private:
    void initStreams();
    bool isEmpty();
    int  sendS6F24(const BS2Message * msg, int ack);
    BS2Message * resetSpooling(BS2Message * msg);      // for S2F43
    void setEnabled(bool tf);

private:
    ACE_Thread_Mutex m_lock;
    MUTEX_Bool       m_full;

    string       m_dir;
    int          m_maxcount;
    JGVariable * m_enable;
    JGVariable * m_actual;              // not zero is that spool active
    JGVariable * m_total;               // the total number of primary message
    JGVariable * m_overwrite;
    JGVariable * m_maxtransmit;
    JGVariable * m_startime;
    JGVariable * m_fulltime;
    BS2TimeValue m_startv;
    BS2TimeValue m_fulltv;
    JGSpoolState * m_spoolState;        // State Model

    JGBitVector m_sfbits;               // spooling enabled bits
    JGSpoolDB   m_spooldb;

};

#endif
