#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    gem_makesrc.py
#
#  @author Fukasawa Mitsuo
#
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

"""
Copyright (C) 2004 BEE Co.,Ltd. All Rights Reserved.
Copyright (C) 2004 FLT Inc. All Rights Reserved.

To use, simply 'import gem_makesrc'.
"""

import sys, os, types, time, string, cStringIO, re
import jyugem

__author__  = "Fukasawa Mitsuo <fukasawa_mitsuo@nifty.com>"
__status__  = "beta"
__version__ = "0.0.1"
__date__    = "12 June 2004"

#---------------------------------------------------------------------------
#   Miscellaneous module data
#---------------------------------------------------------------------------


#---------------------------------------------------------------------------
#   Miscellaneous functions
#---------------------------------------------------------------------------

_c_state_function = """
/*
 * Get %(VARIABLE_NAME)s Item
 */
static int vfei_getval_%(variable_name)s(int ref_id, char ** vfei_str, int * buftype)
{
    *vfei_str = %(c_global_variable)s;
    *buftype = (int)VFEIBUF_STATIC;
    return 0;
}
"""

def print_functions():
    replace = ""
    for name, connector in jyugem.connectors.items():
        replace += _c_state_function % {'VARIABLE_NAME': connector.name_,
                                        'variable_name': string.lower(connector.name_),
                                        'c_global_variable': connector.addr_}
    return replace

#
# Print variable count
#
def print_variable_count():
    return str(len(jyugem.connectors) + 1)

#
# Print variable information table
#
_c_state_varinfo = """    { %(vid)d, "%(VARIABLE_NAME)s", vfei_getval_%(variable_name)s },
"""

def print_variable_definitions():
    replace = ""
    for name, connector in jyugem.connectors.items():
        vid = jyugem.varnames[name].vid
        replace += _c_state_varinfo % {'vid': vid,
                                       'VARIABLE_NAME': connector.name_,
                                       'variable_name': string.lower(connector.name_)}
    return replace

#
# Dispatch items
#
def get_entity(item):
    replace = ""
    if item == "get_value_functions":
        replace = print_functions()
    elif item == "variable_count":
        replace = print_variable_count()
    elif item == "vfei_variable_definitions":
        replace = print_variable_definitions()
    return replace

#---------------------------------------------------------------------------
def make_vfei_var_c():
    tmplfile = "vfei_var.c.tmpl"
    outfile, ext = os.path.splitext(tmplfile)

    mp = re.compile("@\{[a-zA-Z0-9_ ]*\}")

    infp = file(tmplfile)
    outfp = file(outfile, mode='w')
    buf = infp.readline()
    while len(buf) > 0:
        if mp.search(buf) != None:
            iterator = mp.finditer(buf)
            linebuf = ""
            pos = 0
            for match in iterator:
                span = match.span()
                linebuf += buf[pos:span[0]]
                itemname = buf[span[0]+2:span[1]-1]
                ### print "=> ", itemname, ",", span
                repstr = get_entity(itemname)
                linebuf += repstr
                pos = span[1]
            if len(buf) > pos + 1:   # ignore cr/lf
                linebuf += buf[pos:]
            outfp.write(linebuf)
        else:
            outfp.write(buf)
        #
        buf = infp.readline()
    infp.close()
    outfp.close()
    return

