#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    gemsql.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

"""
Copyright (C) 2004 BEE Co.,Ltd. All Rights Reserved.

To use, simply 'import gem_sqlite'.
"""

import sys, os, types, time, string, cStringIO
import jyugem

__author__  = "Fukasawa Mitsuo <fukasawa_mitsuo@nifty.com>"
__status__  = "beta"
__version__ = "0.0.2"
__date__    = "30 May 2004"

#---------------------------------------------------------------------------
#   Miscellaneous module data
#---------------------------------------------------------------------------

#
# G_VARIABLES
#
_sql_insert_varables = """
INSERT INTO G_VARIABLES \
(VID,NAME,SVC_NAME,DATATYPE,FORMAT,SIZE,INIT_VAL,MIN_VAL,MAX_VAL,UNITS,\
OBJTYPE,ATTRIBUTE,SUBSTANTIATOR,LIMIT_CEID,LIMIT_TYPE,ENUM,TRIG_ID,SAVED,\
ENABLED,UPD_DATE,UPD_NAME) VALUES \
(%(vid)d,'%(name)s','%(svc_name)s',%(clazz)d,'%(format)s',%(size)d,'%(initval)s',\
'%(minval)s','%(maxval)s','%(units)s','%(objtype)s','%(attribute)s',\
'%(substantiator)s','%(limceid)s','%(limtype)s','%(enum)s','%(trigger)s',\
'%(saved)s','%(enabled)s','%(update)s','%(editor)s');
"""

def variable_to_insert_statement(variable):
    sml = jyugem.formatUml(variable.format)
    objtypeName = ""
    enumerate = ""
    if variable.objtype != None:
        objtypeName = variable.objtype.typeid
    try:
        enum = jyugem.enums[variable.enumerator]
        enumerate = enum.toString()
    except KeyError:
        pass
    limtype = ""
    # if variable.limit != None:
    #     limtype = variable.limit.name

    sql = _sql_insert_varables % {
        'vid': variable.vid, 'name': variable.name, 'svc_name': variable.name,
        'clazz': variable.clazz, 'format': sml, 'size': variable.size,
        'initval': variable.initval, 'minval': variable.minval,
        'maxval': variable.maxval,
        'units': variable.units, 'objtype': objtypeName, 'attribute': "",
        'substantiator': variable.substantiator, 'limceid': variable.lim_ceid,
        'limtype': limtype, 'enum': enumerate, 'trigger': "",
        'saved': "N", 'enabled': "Y", 'update': "", 'editor': ""
    }
    return sql

def sql_insert_variables(fp):
    print "Making insert variable sql statements"
    for vid, var in jyugem.variables.items():
        statement = variable_to_insert_statement(var)
        fp.writelines(statement)

def sql_insert_variable(fp, vid):
    try:
        var = jyugem.variables[vid]
        statement = variables_to_insert_statement(var)
        fp.writelines(statement)
    except KeyError:
        print "Variable does not found:", vid

#
# G_ALARM
#
_sql_insert_alarm = """
INSERT INTO G_ALARM \
(ALID,NAME,ALTX,ENABLED,ALCD,DISPOSAL,VID,UPD_DATE,UPD_NAME) VALUES \
(%(alid)d,"%(name)s","%(altx)s",'%(enabled)s',%(alcd)d,'%(disposal)s',%(vid)d,\
'%(update)s','%(editor)s');
"""

def alarm_to_insert_statement(alarm):
    sql = _sql_insert_alarm % {
        'alid': alarm.alid, 'altx': alarm.altx, 'name': alarm.name,
        'enabled': "Y", 'alcd': alarm.alcd, 'disposal': "",
        'vid': 100000 + alarm.alid, 'update': "", 'editor': ""
    }
    return sql

def sql_insert_alarms(fp):
    print "Making insert alarm sql statements"
    for alid, alarm in jyugem.alarms.items():
        statement = alarm_to_insert_statement(alarm)
        fp.writelines(statement)

def sql_insert_alarm(fp, alid):
    try:
        alarm = jyugem.alarms[alid]
        statement = alarm_to_insert_statement(alarm)
        fp.writelines(statement)
    except KeyError:
        print "Alarm does not found:", alid

#
# G_EVENT
#
_sql_insert_event = """
INSERT INTO G_EVENT \
(CEID,CENAME,SVC_NAME,ENABLED,CATEGORY,KEY_ITEM,ACTION,UPD_DATE,UPD_NAME) VALUES \
(%(ceid)d,'%(name)s','%(svc_name)s','%(enabled)s','%(category)s','%(keyitem)s',\
'%(action)s','%(update)s','%(editor)s');
"""

def event_to_insert_statement(event):
    sql = _sql_insert_event % {
        'ceid': event.ceid, 'name': event.name, 'svc_name': event.svcname,
        'enabled': "Y", 'category': "", 'keyitem': "", 'action': "",
        'update': "", 'editor': ""
    }
    return sql

#
_sql_insert_evt_report = """
INSERT INTO G_EVTRPT (CEID,RPTID,SEQ_NUM,RPTNAME,UPD_DATE,UPD_NAME) VALUES \
(%(ceid)d,%(rptid)d,%(seq_num)d,'%(rptname)s','%(update)s','%(editor)s');
"""

def evtrpt_to_insert_statement(event):
    sql = ""
    i = 0
    for rptid in event.reports:
        report = jyugem.reports[rptid]
        tuplebuf = _sql_insert_evt_report % {
            'ceid': event.ceid, 'rptid': report.rptid, 'seq_num': i,
            'rptname': report.name, 'update': "", 'editor': ""
        }
        sql += tuplebuf
        sql += "\n"
        i += 1
    return sql

#
def sql_insert_events(fp):
    print "Making insert event sql statements"
    for ceid, event in jyugem.events.items():
        statement = event_to_insert_statement(event)
        fp.writelines(statement)
        statement = evtrpt_to_insert_statement(event)
        fp.writelines(statement)

def sql_insert_event(fp, ceid):
    try:
        event = jyugem.events[ceid]
        statement = event_to_insert_statement(event)
        fp.writelines(statement)
        statement = evtrpt_to_insert_statement(event)
        fp.writelines(statement)
    except KeyError:
        print "Event does not found:", ceid


#
# G_REPORT
#
_sql_insert_report = """
INSERT INTO G_REPORT (RPTID,RPTNAME,UPD_DATE,UPD_NAME) VALUES \
(%(rptid)d,'%(rpt_name)s','%(update)s','%(editor)s');
"""

def report_to_insert_statement(report):
    sql = _sql_insert_report % {
        'rptid': report.rptid, 'rpt_name': report.name,
        'update': "", 'editor': ""
    }
    return sql

#
_sql_insert_rpt_data = """
INSERT INTO G_RPTDATA (RPTID,VID,SEQ_NUM,VARNAME,UPD_DATE,UPD_NAME) VALUES \
(%(rptid)d,%(vid)d,%(seq_num)d,'%(varname)s','%(update)s','%(editor)s');
"""

def rptdata_to_insert_statement(report):
    sql = ""
    i = 0
    for vid in report.vars:
        variable = jyugem.variables[vid]
        tuplebuf = _sql_insert_rpt_data % {
            'rptid': report.rptid, 'vid': vid, 'seq_num': i,
            'varname': variable.name, 'update': "", 'editor': ""
        }
        sql += tuplebuf
        sql += "\n"
        i += 1
    return sql

#
def sql_insert_reports(fp):
    print "Making insert report sql statements"
    for rptid, report in jyugem.reports.items():
        statement = report_to_insert_statement(report)
        fp.writelines(statement)
        statement = rptdata_to_insert_statement(report)
        fp.writelines(statement)

def sql_insert_event(fp, rptid):
    try:
        report = jyugem.reports[rptid]
        statement = event_to_insert_statement(report)
        fp.writelines(statement)
        statement = rptdata_to_insert_statement(report)
        fp.writelines(statement)
    except KeyError:
        print "Report does not found:", rptid


#
# G_OBJECT
#
_sql_insert_objtype = """
INSERT INTO G_OBJTYPE \
(OBJTYPE,NAME,CLASS,CATEGORY,SUPERTYPE,ABSTRACT,PLURAL_NAME,TABLE_NAME,\
UPD_DATE,UPD_NAME) VALUES \
('%(objtype)s','%(name)s',%(clazz)d,'%(category)s','%(supertype)s',\
'%(abstruct)s','%(plural)s','%(table)s','%(update)s','%(editor)s');
"""

def objtype_to_insert_statement(objtype):
    sql = _sql_insert_objtype % {
        'objtype': objtype.typeid, 'name': objtype.name, 'clazz': 0,
        'category': "", 'supertype': "", 'abstruct': "N",
        'plural': "", 'table': "", 'update': "", 'editor': ""
    }
    return sql


#
def sql_insert_objtypes(fp):
    print "Making insert objtype sql statements"
    for typeid, clazz in jyugem.objtypes.items():
        statement = objtype_to_insert_statement(clazz)
        fp.writelines(statement)
        statement = objattr_to_insert_statement(clazz)
        fp.writelines(statement)

def sql_insert_objtype(fp, typeid):
    try:
        objtype = jyugem.objtypes[typeid]
        statement = objtype_to_insert_statement(objtype)
        fp.writelines(statement)
        statement = objattr_to_insert_statement(objtype)
        fp.writelines(statement)
    except KeyError:
        print "ObjType does not found:", typeid


#
# G_ATTRIBUTE
#
_sql_insert_attribute = """
INSERT INTO G_ATTRIBUTE \
(ATTR_ID,NAME,OBJTYPE,FORMAT,SEQ_NUM,VECTOR,DEFAULT_VAL,MIN_NVALS,MAX_NVALS,\
ACCESS,DATATYPE,TYPE_NAME,PLURAL_NAME,VAR_CODE,VARIABLE,STATIC,ENABLED,ENUM,\
UPD_DATE,UPD_NAME) VALUES \
('%(attr_id)s','%(name)s','%(objtype)s','%(format)s',%(seq_num)d,'%(vector)s',\
'%(default_val)s','%(min_nvals)s','%(max_nvals)s',%(access)d,%(datatype)d,\
'%(type_name)s','%(plural_name)s',%(var_code)d,'%(variable)s','%(static)s',\
'%(enabled)s','%(enum)s','%(update)s','%(editor)s');
"""

def objattr_to_insert_statement(objtype):
    sql = ""
    i = 0
    for attr in objtype.attributes:
        tuplebuf = attribute_to_insert_statement(attr, objtype.typeid, i)
        sql += tuplebuf
        sql += "\n"
        i += 1
    return sql


def attribute_to_insert_statement(attribute, objtypeName, i):
    mbr_attr = attribute
    sml = jyugem.formatUml(mbr_attr.format)
    minq = attribute.minq
    maxq = attribute.maxq
    typeName = ""
    datatype = 0
    vect = "N"
    if attribute.substantiator == "vector":
        vect = "Y"
        mbr_attr = attribute.members[0]
        if mbr_attr.struct != None:
            typeName = mbr_attr.struct.typeid
            datatype = 1
            sml = jyugem.formatUml(mbr_attr.format)
    #
    if attribute.substantiator == "object":
        typeName = attribute.struct.typeid
        datatype = 1
    #
    sql = _sql_insert_attribute % {
        'attr_id': attribute.attrid, 'name': attribute.name,
        'objtype': objtypeName,
        'seq_num': i, 'format': sml, 'vector': vect,
        'default_val': mbr_attr.initval, 'min_nvals': minq,
        'max_nvals': maxq, 'access': 0, 'datatype': datatype,
        'type_name': typeName, 'plural_name': "", 'var_code': 0,
        'variable': "", 'static': "Y", 'enabled': "Y", 'enum_base': "",
        'enum': "", 'update': "", 'editor': ""
    }
    #
    #if attribute.substantiator == "object":
    #    j = 0
    #    for cur_attr in attribute.members:
    #        tuplebuf = attribute_to_insert_statement(cur_attr, typeName, j)
    #        sql += tuplebuf
    #        sql += "\n"
    #        j += 1
    return sql



#
# G_CONNECTOR
#
_sql_insert_connector = """
INSERT INTO G_CONNECTOR \
(VID,CONNECT,DOMAIN,ADDRESS,ALGORITHM,ENABLED,UPD_DATE,UPD_NAME) VALUES \
(%(vid)d,'%(contype)s','%(domain)s','%(addr)s','%(algo)s',\
'%(enabled)s','%(update)s','%(editor)s');
"""

def connector_to_insert_statement(connector):
    var = jyugem.varnames[connector.name]
    if var == None:
        print "Variable not found in connector_to_insert_statement:", connector.name_
        return
    sql = _sql_insert_connector % {
        'vid': var.vid, 'contype': connector.connect,
        'domain': connector.domain, 'addr': connector.addr, 'algo': "",
        'enabled': "Y", 'update': "", 'editor': ""
    }
    return sql

def sql_insert_connectors(fp):
    print "Making insert connector sql statements"
    for name, connector in jyugem.connectors.items():
        statement = connector_to_insert_statement(connector)
        fp.writelines(statement)

def sql_insert_connector(fp, name):
    try:
        connector = jyugem.connectors[name]
        statement = connector_to_insert_statement(connector)
        fp.writelines(statement)
    except KeyError:
        print "Connector does not found:", name

#
#
#
_sql_insert_config = """
INSERT INTO G_CONFIG \
(PARAM_NAME,VALUE,UNITS,CATEGORY,SUB_CATEGORY,VID,NOTE,UPD_DATE,UPD_NAME) VALUES \
('%(pname)s','%(pvalue)s','%(units)s','%(category)s','%(sub_category)s',\
'%(vid)s','%(note)s','%(update)s','%(editor)s');
"""

#
def sql_insert_configurations(fp, configs):
    print "Making insert configuration sql statements"
    sql_insert_comm_config(fp, jyugem.comm_params)
    sql_insert_datadef_config(fp)
    sql_insert_vfei_config(fp, configs)

#
def config_to_insert_statement(name, value, category = "", sub_category = "",
                               units = "", vid = "", note = "", update = "",
                               editor = ""):
    sql = _sql_insert_config % {
        'pname': name, 'pvalue': value, 'units': units, 'category': category,
        'sub_category': sub_category, 'vid': vid, 'note': note,
        'update': update, 'editor': editor
    }
    return sql

#
def sql_insert_comm_config(fp, comm_config, username = ""):
    if comm_config == None:
        print "ERROR: No setting parameter object in jyugem."
        return
    now = time.strftime("%Y/%m/%d %H:%M:%S", time.localtime())
    # secs speccification
    sql = config_to_insert_statement(name = "Device Number",
                                     value = comm_config.devid,
                                     category = "System",
                                     update = now, editor = username)
    fp.writelines(sql)
    sql = config_to_insert_statement(name = "Source ID",
                                     value = comm_config.srcid,
                                     category = "System",
                                     update = now, editor = username)
    fp.writelines(sql)
    sql = config_to_insert_statement(name = "Equipment Name",
                                     value = comm_config.devname,
                                     category = "System",
                                     update = now, editor = username)
    fp.writelines(sql)

    # communication paramaetes
    sub_cate = string.upper(comm_config.protocol)
    sql = config_to_insert_statement(name = "Protocol",
                                     value = sub_cate,
                                     category = "COMMUNICATION",
                                     sub_category = "PROTOCOL",
                                     update = now, editor = username)
    fp.writelines(sql)

    if string.upper(comm_config.role) == "MASTER":
        role_flag ="YES"
    else:
        role_flag = "NO"
    sql = config_to_insert_statement(name = "Master",
                                     value = role_flag,
                                     category = "COMMUNICATION",
                                     sub_category = "PROTOCOL",
                                     update = now, editor = username)
    fp.writelines(sql)

    if sub_cate == "HSMS":
        sql = config_to_insert_statement(name = "IP",
                                         value = comm_config.ipaddr,
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "Port",
                                         value = comm_config.port,
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T3H",
                                         value = comm_config.t3,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T5",
                                         value = comm_config.t5,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T6",
                                         value = comm_config.t6,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T7",
                                         value = comm_config.t7,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T8",
                                         value = comm_config.t8,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "HSMS",
                                         update = now, editor = username)
        fp.writelines(sql)
    else:
        sql = config_to_insert_statement(name = "Baudrate",
                                         value = comm_config.ipaddr,
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "Comm Port",
                                         value = comm_config.port,
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "Retry",
                                         value = comm_config.retry,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T1",
                                         value = comm_config.t1,
                                         units = "100msec",
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T2",
                                         value = comm_config.t2,
                                         units = "100msec",
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T3S",
                                         value = comm_config.t3,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)
        sql = config_to_insert_statement(name = "T4",
                                         value = comm_config.t4,
                                         units = "sec",
                                         category = "COMMUNICATION",
                                         sub_category = "SECS",
                                         update = now, editor = username)
        fp.writelines(sql)

#
def sql_insert_datadef_config(fp, username = ""):
    now = time.strftime("%Y/%m/%d %H:%M:%S", time.localtime())
    for idname, val in jyugem.datadef.items():
        parname = "%s Format" % (idname)
        sql = config_to_insert_statement(name = parname,
                                         value = val,
                                         category = "DATADEF",
                                         update = now, editor = username)
        fp.writelines(sql)

#
def sql_insert_vfei_config(fp, configs, username = ""):
    now = time.strftime("%Y/%m/%d %H:%M:%S", time.localtime())
    # secs speccification
    for pname, pvalue in configs.items():
        if pname == "peer port" and len(pvalue) > 0:
            sql = config_to_insert_statement(name = "VFEI Peer Port",
                                             value = pvalue,
                                             category = "VFEI",
                                             update = now, editor = username)
            fp.writelines(sql)
        if pname == "mbx" and len(pvalue) > 0:
            sql = config_to_insert_statement(name = "MailBox",
                                             value = pvalue,
                                             category = "VFEI",
                                             update = now, editor = username)
            fp.writelines(sql)



#-------------------------------------------------------------------------------
# Create Tables
#
_sql_create_alarm = """
CREATE TABLE G_ALARM \
("ALID" VARCHAR(64) PRIMARY KEY, "NAME" VARCHAR(64) NOT NULL, \
 "ALTX" VARCHAR(160) NOT NULL, "ENABLED" CHAR(1), "ALCD" INTEGER, \
 "DISPOSAL" VARCHAR(254), "VID" VARCHAR(64), \
 "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_attribute = """
CREATE TABLE G_ATTRIBUTE \
("ATTR_ID" VARCHAR(254) PRIMARY KEY, "NAME" VARCHAR(64), "OBJTYPE" VARCHAR(254), \
 "FORMAT" VARCHAR(16), "SEQ_NUM" INTEGER, "VECTOR" CHAR(1), \
 "DEFAULT_VAL" VARCHAR(254), "MIN_NVALS" INTEGER, "MAX_NVALS" INTEGER, \
 "ACCESS" INTEGER, "DATATYPE" INTEGER, "TYPE_NAME" VARCHAR(254), \
 "PLURAL_NAME" VARCHAR(254), "VAR_CODE" INTEGER, "VARIABLE" VARCHAR(254), \
 "STATIC" CHAR(1), "ENABLED" CHAR(1), "ENUM" TEXT,
 "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_config = """
CREATE TABLE G_CONFIG \
("PARAM_NAME" VARCHAR(254) PRIMARY KEY, "VALUE" VARCHAR(254), "UNITS" VARCHAR(16), \
 "CATEGORY" VARCHAR(254), "SUB_CATEGORY" VARCHAR(254), "VID" VARCHAR(64), \
 "NOTE" TEXT, "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_connector = """
CREATE TABLE G_CONNECTOR \
("VID" VARCHAR(64) PRIMARY KEY, "CONNECT" VARCHAR(254), "DOMAIN" VARCHAR(254), \
 "ADDRESS" VARCHAR(64), "ALGORITHM" TEXT, "ENABLED" CHAR(1), \
 "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_event = """
CREATE TABLE G_EVENT \
("CEID" VARCHAR(64) PRIMARY KEY, "CENAME" VARCHAR(254), "SVC_NAME" VARCHAR(254), \
 "ENABLED" CHAR(1), "CATEGORY" VARCHAR(254), "KEY_ITEM" VARCHAR(64), \
 "ACTION" TEXT, "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_evt_report = """
CREATE TABLE G_EVTRPT \
("CEID" VARCHAR(64), "RPTID" VARCHAR(64), "SEQ_NUM" INTEGER, \
 "RPTNAME" VARCHAR(64), "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_objtype = """
CREATE TABLE G_OBJTYPE \
("OBJTYPE" VARCHAR(254) PRIMARY KEY, "NAME" VARCHAR(254), "CLASS" INTEGER, \
 "CATEGORY" VARCHAR(64), "SUPERTYPE" VARCHAR(254), "ABSTRACT" CHAR(1), \
 "PLURAL_NAME" VARCHAR(254), "TABLE_NAME" VARCHAR(254), \
 "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_report = """
CREATE TABLE G_REPORT \
("RPTID" VARCHAR(64) PRIMARY KEY, "RPTNAME" VARCHAR(64),
 "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_rptdata = """
CREATE TABLE G_RPTDATA \
("RPTID" VARCHAR(64), "VID" VARCHAR(64), "SEQ_NUM" INTEGER, \
 "VARNAME" VARCHAR(64), "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

_sql_create_variables = """
CREATE TABLE G_VARIABLES \
("VID" VARCHAR(64) PRIMARY KEY, "NAME" VARCHAR(64), "SVC_NAME" VARCHAR(64), \
 "DATATYPE" INTEGER, "FORMAT" VARCHAR(16), "SIZE" INTEGER, \
 "INIT_VAL" VARCHAR(254), "MIN_VAL" VARCHAR(254), "MAX_VAL" VARCHAR(254), \
 "UNITS" VARCHAR(16), "OBJTYPE" VARCHAR(254), "ATTRIBUTE" VARCHAR(254), \
 "SUBSTANTIATOR" VARCHAR(254), "LIMIT_CEID" VARCHAR(64), \
 "LIMIT_TYPE" VARCHAR(64), "ENUM" text, "TRIG_ID" VARCHAR(64), "SAVED" CHAR(1), \
 "ENABLED" CHAR(1), "UPD_DATE" DATETIME, "UPD_NAME" VARCHAR(254));
"""

#
#
#
def sql_create_tables(fp):
    fp.write("BEGIN TRANSACTION;\n")
    fp.write(_sql_create_alarm)
    fp.write(_sql_create_attribute)
    fp.write(_sql_create_config)
    fp.write(_sql_create_connector)
    fp.write(_sql_create_event)
    fp.write(_sql_create_evt_report)
    fp.write(_sql_create_objtype)
    fp.write(_sql_create_report)
    fp.write(_sql_create_rptdata)
    fp.write(_sql_create_variables)
    fp.write("COMMIT;\n")

#
#
#
def sql_drop_tables(fp):
    fp.write("BEGIN TRANSACTION;\n")
    fp.write("DROP TABLE G_ALARM;\n")
    fp.write("DROP TABLE G_ATTRIBUTE;\n")
    fp.write("DROP TABLE G_CONFIG;\n")
    fp.write("DROP TABLE G_CONNECTOR;\n")
    fp.write("DROP TABLE G_EVENT;\n")
    fp.write("DROP TABLE G_EVTRPT;\n")
    fp.write("DROP TABLE G_OBJTYPE;\n")
    fp.write("DROP TABLE G_REPORT;\n")
    fp.write("DROP TABLE G_RPTDATA;\n")
    fp.write("DROP TABLE G_VARIABLES;\n")
    fp.write("COMMIT;\n")

#
#
#
def make_sql(filename, configs):
    fp = open(filename, mode='w')
    #
    sql_drop_tables(fp)
    sql_create_tables(fp)
    #
    fp.write("BEGIN TRANSACTION;\n")
    sql_insert_configurations(fp, configs)
    sql_insert_variables(fp)
    sql_insert_alarms(fp)
    sql_insert_events(fp)
    sql_insert_reports(fp)
    sql_insert_objtypes(fp)
    sql_insert_connectors(fp)
    fp.write("COMMIT;\n")
    fp.close()
    #
    print "Finish to make sql file:", filename
