#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    jyugem.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

"""
Copyright (C) 2004 BEE Co.,Ltd. All Rights Reserved.

To use, simply 'import jyugem'.
"""

import sys, os, types, time, string, cStringIO

try:
    import thread
    import threading
except ImportError:
    thread = None

__author__  = "Fukasawa Mitsuo <fukasawa_mitsuo@nifty.com>"
__status__  = "beta"
__version__ = "0.0.1"
__date__    = "26 May 2004"

#---------------------------------------------------------------------------
#   Miscellaneous module data
#---------------------------------------------------------------------------

variables = dict()
varnames = dict()
events = dict()
reports = dict()
objtypes = dict()
alarms = dict()
enums = dict()
connectors = dict()
datadef = dict()
comm_params = None

#---------------------------------------------------------------------------
#   Miscellaneous functions
#---------------------------------------------------------------------------
def formatStr(format):
    if format == 0:
        return "list"
    elif format == 010:
        return "binary"
    elif format == 011:
        return "boolean"
    elif format == 020:
        return "ascii"
    elif format == 021:
        return "jis"
    elif format == 022:
        return "unicode"
    elif format == 030:
        return "int8"
    elif format == 031:
        return "int1"
    elif format == 032:
        return "int2"
    elif format == 034:
        return "int4"
    elif format == 040:
        return "float8"
    elif format == 044:
        return "float4"
    elif format == 050:
        return "uint8"
    elif format == 051:
        return "uint1"
    elif format == 052:
        return "uint2"
    elif format == 054:
        return "uint4"
    return ""

def formatUml(format):
    if format == 0:
        return "L"
    elif format == 010:
        return "B"
    elif format == 011:
        return "BOOLEAN"
    elif format == 020:
        return "A"
    elif format == 021:
        return "J"
    elif format == 022:
        return "UNICODE"
    elif format == 030:
        return "I8"
    elif format == 031:
        return "I1"
    elif format == 032:
        return "I2"
    elif format == 034:
        return "I4"
    elif format == 040:
        return "F8"
    elif format == 044:
        return "F4"
    elif format == 050:
        return "U8"
    elif format == 051:
        return "U1"
    elif format == 052:
        return "U2"
    elif format == 054:
        return "U4"
    return ""
#
def strToFormat(fmtstr):
    if fmtstr == "list":
        return 0
    elif fmtstr == "binary":
        return 010
    elif fmtstr == "boolean":
        return 011
    elif fmtstr == "ascii":
        return 020
    elif fmtstr == "jis":
        return 021
    elif fmtstr == "unicode":
        return 022
    elif fmtstr == "int1":
        return 031
    elif fmtstr == "int2":
        return 032
    elif fmtstr == "int4":
        return 034
    elif fmtstr == "int8":
        return 030
    elif fmtstr == "float4":
        return 044
    elif fmtstr == "float8":
        return 040
    elif fmtstr == "uint1":
        return 051
    elif fmtstr == "uint2":
        return 052
    elif fmtstr == "uint4":
        return 054
    elif fmtstr == "uint8":
        return 050
    return 0

def smlToFormat(fmtstr):
    if fmtstr == "L":
        return 0
    elif fmtstr == "B":
        return 010
    elif fmtstr == "BOOLEAN":
        return 011
    elif fmtstr == "A":
        return 020
    elif fmtstr == "J":
        return 021
    elif fmtstr == "UNICODE":
        return 022
    elif fmtstr == "I1":
        return 031
    elif fmtstr == "I2":
        return 032
    elif fmtstr == "I4":
        return 034
    elif fmtstr == "I8":
        return 030
    elif fmtstr == "F4":
        return 044
    elif fmtstr == "F8":
        return 040
    elif fmtstr == "U1":
        return 051
    elif fmtstr == "U2":
        return 052
    elif fmtstr == "U4":
        return 054
    elif fmtstr == "U8":
        return 050
    return 0


#---------------------------------------------------------------------------
#   SECS classes
#---------------------------------------------------------------------------
class CommParameter:
    def __init__(self, protocol):
        self.devname = ""
        self.devid = "0"
        self.srcid = "0"
        self.protocol = protocol
        self.role = ""

    def setEquipmentName(self, name):
        self.devname = name

    def setDeviceID(self, id):
        self.devid = id

    def setRole(self, role):
        self.role = role


class SECSParameter(CommParameter):
    def __init__(self):
        CommParameter.__init__(self, "SECS")
        self.port = "COM1"
        self.baudrate = "9600"
        self.retry = "3"
        self.t1 = "5"
        self.t2 = "100"
        self.t3 = "45"
        self.t4 = "45"

    def setCommPort(self, portName, baudrate, retry):
        self.port = portName
        self.baudrate = str(baudrate)
        self.retry = str(retry)

    def setTime(self, t1, t2, t3, t4):
        self.t1 = str(t1)
        self.t2 = str(t2)
        self.t3 = str(t3)
        self.t4 = str(t4)


class HSMSParameter(CommParameter):
    def __init__(self):
        CommParameter.__init__(self, "HSMS")
        self.ipaddr = "localhost"
        self.port = "5000"
        self.t3 = "45"
        self.t5 = "10"
        self.t6 = "5"
        self.t7 = "10"
        self.t8 = "5"

    def setIPAddress(self, addr, port):
        self.port = str(port)
        self.ipaddr = addr

    def setTime(self, t3, t5, t6, t7, t8):
        self.t3 = str(t3)
        self.t5 = str(t5)
        self.t6 = str(t6)
        self.t7 = str(t7)
        self.t8 = str(t8)

#
def setup_hsms_parameter():
    global comm_params
    comm_params = HSMSParameter()
    return comm_params

def setup_secs_parameter():
    global comm_params
    comm_params = SECSParameter()
    return comm_params


#---------------------------------------------------------------------------
#   GEM classes
#---------------------------------------------------------------------------

class Variable:
    """
    A Variable instance represents an variable of Equipment.

    Variable instances are created initial time is started.
    """
    def __init__(self, vid, name, svcname, clazz, format, substantiator,
                 objtype = None, size = 1,
                 initval = "", minval = "", maxval = "", units = "",
                 limit = ""):
        """
        Initialize a variable with interesting information.
        """
        self.vid = vid
        self.name = name
        self.svcname = svcname
        self.clazz = clazz
        self.format = format
        self.size = size
        self.initval = initval
        self.minval = minval
        self.maxval = maxval
        self.value = initval
        self.units = units
        self.substantiator = substantiator
        self.objtype = objtype
        self.attribute = None
        self.enumerator = ""
        self.connector = None
        self.lim_ceid = limit
        self.limit = None
        self.trigger = None

    def __str__(self):
        return '<Variable: %s, %s, %s, %s>'%(self.name, self.vid,
            self.format, self.value)

    def toXml(self, nest):
        indent = "".ljust(nest * 2)
        xml = indent
        xml += '<variable vid="%d" name="%s" format="%s">' % (self.vid, self.name,
                                                              formatStr(self.format))
        xml += str(self.initval)
        xml += '</variable>\n'
        return xml

#
# Event class
#
class Event:
    """
    A Event instance represents an event of GEM.

    Event instances are created initial time is started.
    """
    def __init__(self, ceid, name, svcname = ""):
        """
        Initialize a variable with interesting information.
        """
        self.ceid = ceid
        self.name = name
        self.svcname = name
        self.category = ""
        self.key_item = ""
        self.action = ""
        self.reports = []

    def add(self, report):
        self.reports.append(report.rptid)

    def toXml(self):
        xml = '<event ceid="%d" name="%s">\n' % (self.ceid, self.name)
        for rptid in self.reports:
            report = reports[rptid]
            xml += report.toXml(1)
        xml += '</event>\n'
        return xml

#
#
#
class Report:
    """
    A Report instance represents an event of GEM.

    Report instances are created initial time is started.
    """
    def __init__(self, rptid, name):
        """
        Initialize a variable with interesting information.
        """
        self.name = name
        self.rptid = rptid
        self.vars = []

    def add(self, var):
        self.vars.append(var.vid)

    def toXml(self, nest):
        indent = "".ljust(nest * 2)
        xml = indent
        xml += '<report rptid="%d" name="%s">' % (self.rptid, self.name)
        for vid in self.vars:
            # var = variables[vid]
            # xml += var.toXml(nest + 1)
            xml += str(vid)
            xml += " "
        # xml += indent
        xml += '</report>\n'
        return xml

#
#
#
class ObjType:
    """
    A ObjType instance represents an event of GEM.

    ObjType instances are created initial time is started.
    """
    def __init__(self, typeid, name):
        """
        Initialize a variable with interesting information.
        """
        self.typeid = typeid
        self.name = name
        self.category = ""
        self.tablename = ""
        self.attributes = []

    def add(self, attr):
        q = len(self.attributes)
        if q > 0:
            mbr_attr = self.attributes[q - 1]
            if mbr_attr.can_member():
                mbr_attr.add(attr)
            else:
                self.attributes.append(attr)
        else:
            self.attributes.append(attr)

    def toXml(self):
        xml = '<objtype name="%s">\n' % self.typeid
        for attr in self.attributes:
            xml += attr.toXml(1)
        xml += '</objtype>\n'
        return xml


#
#
#
class Attribute:
    """
    A Attribute instance represents an event of GEM.

    Attribute instances are created initial time is started.
    """
    def __init__(self, name, format, objtype, substantiator = "", initval = ""):
        """
        Initialize a variable with interesting information.
        """
        self.attrid = objtype.typeid + '/' + name
        self.name = name
        self.format = format
        self.objtype = objtype
        self.substantiator = substantiator
        self.initval = initval
        self.minq = 0
        self.maxq = 0
        self.max_member = 1    # for "object"
        self.struct = None
        self.access = 1
        self.enumerator = ""
        self.enabled = True
        self.members = []

    def can_member(self):
        if self.substantiator == "vector":
            if len(self.members) == 0:
                return True
            return self.members[0].can_member()
        elif self.substantiator == "object":
            q = len(self.members)
            if (q > 0 and self.members[q-1].can_member()):
                return True
            if self.max_member > q:
                return True
            return False
        else:
            return False

    def add(self, attr):
        q = len(self.members)
        if q == 0:
            self.members.append(attr)
            if self.struct != None:
                self.struct.add(attr)
        else:
            lastAttr = self.members[q - 1]
            if lastAttr.can_member():
                lastAttr.add(attr)
            else:
                self.members.append(attr)
                if self.struct != None:
                    self.struct.add(attr)

    def toXml(self, nest):
        indent = "".ljust(nest * 2)
        xml = ""
        if self.substantiator == "vector":
            xml += ('%s<list>\n' % indent)
            xml += self.members[0].toXml(nest + 1)
            xml += ('%s</list>\n' % indent)
        elif self.substantiator == "object":
            xml += ('%s<list>\n' % indent)
            for mbr in self.members:
                xml += mbr.toXml(nest + 1)
            xml += ('%s</list>\n' % indent)
        else:
            xml = indent
            xml += '<attribute name="%s" format="%o">' % (self.name, self.format)
            xml += self.initval
            xml += '</attribute>\n'
        return xml


#-------------------------------------------------------------------------------
# Alarm Class
#
class Alarm:
    """
    A Alarm instance represents an event of GEM.

    Alarm instances are created initial time is started.
    """
    def __init__(self, alid, name, altx, alcd, ceidon = 0, ceidoff = 0):
        """
        Initialize a variable with interesting information.
        """
        self.alid = alid
        self.name = name
        self.altx = altx
        self.alcd = alcd
        self.on_ceid = ceidon
        self.off_ceid = ceidoff


class Enumerate:
    """
    A Enumerate instance represents an event of GEM.

    Enumerate instances are created initial time is started.
    """
    def __init__(self, name):
        """
        Initialize a variable with interesting information.
        """
        self.name = name
        self.byNum = dict()
        self.byName = dict()

    def add(self, num, name):
        self.byName[name] = num
        self.byNum[num] = name

    def value(self, id):
        if type(id) is int:
            return self.byNum[id]
        return self.byName[id]

    def toString(self):
        # enumstr = "enum " + self.name + " {"
        enumstr = ""
        first = True
        for i, m in self.byNum.items():
            if first:
                first = False
            else:
                enumstr += ', '
            enumstr += ("%s = %d" % (m, i))
        # enumstr += "};"
        return enumstr


class Connector:
    """
    A Connector instance represents an accessing of variable.

    Connector instances are created initial time is started.
    """
    def __init__(self, name, type = "", addr = "", domain = ""):
        """
        Initialize a variable with interesting information.
        """
        self.name = name
        self.connect = type
        self.domain = domain
        self.addr = addr

    def toString(self):
        connstr = '%s [%s] = "%s:%s"' % (self.name, self.connect, self.domain,
                                     self.addr)
        return connstr


class Subsystem:
    """
    A Subsystem instance represents an module of equipment.

    Subsystem instances are created initial time is started.
    """
    def __init__(self, id, name, type = "", addr = "", domain = ""):
        """
        Initialize a variable with interesting information.
        """
        self.id = id
        self.name = name
        self.type = type
        self.reloc = reloc
        self.objspec = objspec
        self.mate_type = 0
        self.locid = 0
        self.enabled = 0
        self.devices = {}

    def toString(self):
        substr = '%d [%s]' % (self.id, self.name)
        for name, dev in self.devices.items():
            substr = substr + dev.toString()
        return substr


class IODevice:
    """
    A IODevice instance represents an i/o device of equipment.

    IODevice instances are created initial time is started.
    """
    def __init__(self, id, name, type = "", subsys_id = "", dataq = ""):
        """
        Initialize a variable with interesting information.
        """
        self.id = id
        self.name = name
        self.type = type
        self.subsys = subsys_id
        self.dataq = dataq
        self.interlock = ""
        self.min_val = ""
        self.max_val = ""
        self.time_enabled = False
        self.interval = ""
        self.access_time = ""
        self.delta = ""
        self.value = ""
        self.vendor = ""
        self.model = ""
        self.revision = ""
        self.enabled = True
        self.sacs = {}

    def toString(self):
        devstr = '%d [%s]' % (self.id, self.name)
        for name, sac in self.devices.items():
            devstr = substr + sac.toString()
        return devstr


class Sac:
    """
    A Sac instance represents an SAC of I/O Device.

    Sac instances are created initial time is started.
    """
    def __init__(self, id, name, type = "", subsys_id = "", dataq = ""):
        """
        Initialize a variable with interesting information.
        """
        self.id = id
        self.name = name
        self.type = type
        self.iodev = iodev_id
        self.format = 0
        self.address = ""
        self.value = ""
        self.algorithm = ""
        self.enabled = True
        self.sacs = {}

    def toString(self):
        sacstr = '%d [%s]' % (self.id, self.name)
        return devstr


class Trigger:
    """
    A Trigger instance represents an trigger of Equipment.

    Trigger instances are created initial time is started.
    """
    def __init__(self, id, name, type = "", manager = "", dataq = ""):
        """
        Initialize a variable with interesting information.
        """
        self.id = id
        self.name = name
        self.type = type
        self.manager = manager
        self.vid = 0
        self.priority = 0
        self.algorithm = ""
        self.enabled = True

    def toString(self):
        trigstr = '%d [%s]' % (self.id, self.name)
        return trigstr


class Trace:
    """
    A Trace instance represents an trace of Equipment.

    Trace instances are created initial time is started.
    """
    def __init__(self, id, name, type = "", manager = "", dataq = ""):
        """
        Initialize a variable with interesting information.
        """
        self.id = id
        self.name = name
        self.type = type
        self.dsper = dsper
        self.totsmp = totsmp
        self.repgsz = repgsz
        self.vars = {}

    def toString(self):
        trigstr = '%d [%s]' % (self.id, self.name)
        return trigstr


class Limit:
    """
    A Limit instance represents an limit of Equipment.

    Limit instances are created initial time is started.
    """

    class DeadBand:
        def __init__(self, lowerdb, upperdb, enabled):
            self.limitid = 0
            self.lowerdb = lowerdb
            self.upperdb = upperdb
            self.enabled = enabled

        def toString():
            if self.enabled:
                enable = "true"
            else:
                enable = "false"
            dbstr = "{%d: %s %s %s} " % (self.limitid,
                                         self.lowerdb,
                                         self.upperdb,
                                         enable)
            return dbstr

    def __init__(self, type, units, min_val = "", max_val = ""):
        """
        Initialize a variable with interesting information.
        """
        self.type = type
        self.units = units
        self.min_val = min_val
        self.max_val = max_val
        self.enabled = True
        self.dir = 0;
        self.recentid = 0
        self.dbs = []

    def adddb(deadband):
        deadband.limitid = len(self.dbs)
        self.dbs.append(deadband)

    def toString(self):
        limstr = '%d [%s]' % (self.type, self.units)
        for db in self.dbs:
            limstr = limstr + db.toString();
        return limstr


class RemoteCommand:
    """
    A RemoteCommand instance represents an command of Host.

    RemoteCommand instances are created initial time is started.
    """

    class Parameter:
        def __init__(self, name, value):
            self.name = name
            self.value = value

        def toString():
            paramstr = "%s = %s" % (self.name, self.value)
            return paramstr


    def __init__(self, name, cmd = 0, sf = "S2F41", max_val = ""):
        """
        Initialize a variable with interesting information.
        """
        self.name = name     # command name
        self.cmd = cmd       # command id
        self.sf = sf
        self.params = []

    def add(param):
        self.params.append(param)

    def toString(self):
        rcmdstr = '%s = {' % (self.name)
        for param in self.params:
            rcmdstr = rcmdstr + param.toString();
            rcmdstr += ", "
        rcmdstr = rcmdstr[:-2]
        rcmdstr += "}\n"
        return rcmdstr

