#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_objtype.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_OBJTYPE, G_ATTRIBUTE
#
objtype_fields = ['OBJTYPE','NAME','CLASS','CATEGORY','SUPERTYPE','ABSTRACT',
                  'PLURAL_NAME','TABLE_NAME']
attr_fields = ['LABEL','ATTR_ID','NAME','OBJTYPE','FORMAT','SEQ_NUM','VECTOR',
               'DEFAULT_VAL','MIN_NVALS','MAX_NVALS','ACCESS','DATATYPE',
               'TYPE_NAME','PLURAL_NAME','VAR_CODE','VARIABLE','STATIC',
               'ENABLED','ENUM']

_insert_objtype = """
insert into g_objtype \
(OBJTYPE,NAME,CLASS,CATEGORY,SUPERTYPE,ABSTRACT,PLURAL_NAME,TABLE_NAME,\
UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
"""
_insert_attr = """
insert into g_attribute \
(ATTR_ID,NAME,OBJTYPE,FORMAT,SEQ_NUM,VECTOR,DEFAULT_VAL,MIN_NVALS,MAX_NVALS,\
ACCESS,DATATYPE,TYPE_NAME,PLURAL_NAME,VAR_CODE,VARIABLE,STATIC,ENABLED,ENUM,\
UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
"""

def ins_objtype(cn, filename):
    reader = csv.DictReader(file(filename), objtype_fields)

    cn.execute("delete from g_objtype");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['OBJTYPE']) > 0:
            cn.execute(_insert_objtype, (row['OBJTYPE'],
                                         row['NAME'],
                                         row['CLASS'],
                                         row['CATEGORY'],
                                         row['SUPERTYPE'],
                                         row['ABSTRACT'],
                                         row['PLURAL_NAME'],
                                         row['TABLE_NAME'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_attr(cn, filename):
    reader = csv.DictReader(file(filename), attr_fields)

    cn.execute("delete from g_attribute");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['ATTR_ID']) > 0:
            cn.execute(_insert_attr, (row['ATTR_ID'],
                                      row['NAME'],
                                      row['OBJTYPE'],
                                      row['FORMAT'],
                                      row['SEQ_NUM'],
                                      row['VECTOR'],
                                      row['DEFAULT_VAL'],
                                      row['MIN_NVALS'],
                                      row['MAX_NVALS'],
                                      row['ACCESS'],
                                      row['DATATYPE'],
                                      row['TYPE_NAME'],
                                      row['PLURAL_NAME'],
                                      row['VAR_CODE'],
                                      row['VARIABLE'],
                                      row['STATIC'],
                                      row['ENABLED'],
                                      row['ENUM'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_objtype(cn, csvdir + os.sep + "objtype.csv")
    ins_attr(cn, csvdir + os.sep + "attribute.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_objtype(db, csvdir + os.sep + "objtype.csv")
    ins_attr(db, csvdir + os.sep + "attribute.csv")
    #
    db.close()

#
def usage():
    print("g_objtype [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

