#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    gemdb.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv

tables = dict()

#
def datatype(itemtype, size):
    field = ""
    if itemtype == "VARCHAR":
        if int(size) <= 255:
            field = "varchar(%d)" % int(size);
        elif int(size) <= 65535:
            field = "text";
        else:
            field = "longtext";
    elif itemtype == "INTEGER":
        field = "integer";
    elif itemtype == "REAL":
        field = "float";
    elif itemtype == "DATE":
        field = "datetime"
    elif itemtype == "TIME":
        field = "time"
    elif itemtype == "TIMESTAMP":
        field = "timestamp"
    elif itemtype == "BOOLEAN":
        field = "varchar(1)"
    return field

#
class Table:
    """
    A Table instance represents an table of database.
    """
    def __init__(self, name):
        self.name_ = name
        self.products_ = ""
        self.items_ = []

    def add(self, column):
        self.items_.append(column)

    def toSql(self):
        q = 0
        sql = "create table " + self.name_ + " ("
        for item in self.items_:
            if q == 0:
                pass
            else:
                sql += ", "
            q += 1
            sql += item.toSql()
        sql += ")"
        return sql

#
class Item:
    """
    A Item instance represents an table of database.
    """
    def __init__(self, name, type, size, null = True, primary = False):
        self.name_ = name
        self.type_ = type
        self.size_ = size
        self.null_ = null
        self.primary_ = primary
        self.products_ = ""

    def toSql(self):
        sql = self.name_ + " "
        sql += datatype(self.type_, self.size_)
        if self.primary_:
            sql += " primary key "
        elif not self.null_:
            sql += " not null "
        return sql

#
fields = ['NAME', 'TABLE', 'ITEM_JP', 'ITEM', 'TYPE', 'SIZE', 'KEY',
          'DEFAULT', 'NULL', 'REF_TABLE', 'REF_ITEM', 'PRODUCTS', 'COMMENT',
          'UPDATE']

#
_last_table = None

def load_schema(filename):
    #reader = csv.reader(file(filename), dialect='excel')
    reader = csv.DictReader(file(filename), fields)

    sql = ""
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if (len(row['NAME']) > 0 and len(row['ITEM']) > 0):
            tableName = row['TABLE']
            tables[tableName] = Table(tableName)
            #
            _last_table = tables[tableName]
            if row["PRODUCTS"] == "NOT_USE":
                _last_table.products_ = "NOT_USE"
            #
            datatype = row["TYPE"]
            size = row["SIZE"]
            #size = int(row["SIZE"])
            key = False
            null = True
            if row["KEY"] == "Y":
                key = True
            if row["NULL"] == "N" or key:
                null = False
            item = Item(row['ITEM'], datatype, size, null, key)
            _last_table.add(item)
        elif len(row['ITEM']) > 0 and row['PRODUCTS'] != "IGNORE":
            _last_table = tables[tableName]
            datatype = row["TYPE"]
            size = row["SIZE"]
            #size = int(row["SIZE"])
            key = False
            null = True
            if row["KEY"] == "Y":
                key = True
            if row["NULL"] == "N" or key:
                null = False
            item = Item(row['ITEM'], datatype, size, null, key)
            _last_table.add(item)
        #
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
# Test main
#
def main():
    filename = 'gemdb.csv'
    load_schema(filename)
    for name, table in tables.items():
        if table.products_ == "NOT_USE":
            continue
        print table.toSql()
        print "\n\n"


if __name__ == "__main__":
    main()
