// $Id$

//=============================================================================
/**
 *  @file    alarm_report_message.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#define BEE_BUILD_DLL

#include "jyugem/cell/host_message.h"
#include <sstream>

namespace jyugem { namespace cell
{

void report_message::append(const any_item& mbr)
{
    TRACE_FUNCTION(TRL_LOW, "report_message::append");

    if (mbr.name() == "ERROR_CODE")
    {
        m_errcode = mbr.m_value.getInt();
    }
    else if (mbr.name() == "ERROR_TEXT")
    {
        m_errtext = mbr.m_value.toString();
    }
    else if (mbr.name() == "FILE")
    {
        m_file = mbr.m_value.toString();
    }
    this->rcmd::append(mbr);
}

//-----------------------------------------------------------------------------
void alarm_report_message::append(const any_item& mbr)
{
    TRACE_FUNCTION(TRL_LOW, "alarm_report_message::append");

    if (mbr.name() == "ALARM_ID")
    {
        m_alid = mbr.m_value.getInt();
    }
    else if (mbr.name() == "ALARM_STATE")
    {
        m_alstate = mbr.m_value.getBool();
    }
    else if (mbr.name() == "ALARM_TEXT")
    {
        m_altx = mbr.m_value.toString();
    }
    else if (mbr.name() == "ALARM_CATEGORY")
    {
        m_alcd = (BYTE)mbr.m_value.getInt();
    }
    this->rcmd::append(mbr);
}

int alarm_report_message::toVfei(std::string& outstr)
{
    BCHAR buf[256];

    outstr = _TX("CMD/A=\"ALARM_REPORT\" MID/A=\"");
    outstr += m_devid;
    outstr += _TX("\" MTY/A=\"E\" ");
    _stprintf(buf, _TX("ECD/U4=%u ETX/A=\"%s\""), m_errcode,
                                                  m_errtext.c_str());
    outstr += buf;
    _stprintf(buf, _TX("ALARM_ID/%s=%d ALARM_STATE/U1=%d ALARM_TEXT/A=\""),
                   _TX("I4"), m_alid, ((m_alstate) ? 1 : 0));
    outstr += buf;
    outstr += m_altx;
    outstr += _TX("\" ");
    _stprintf(buf, _TX("ALARM_CATEGORY/U1=%d"), m_alcd);
    outstr += buf;
    return (int)outstr.size();
}

int alarm_report_message::toXml(std::string& outstr)
{
    std::ostringstream ost;
    ost << m_indent << _TX("<AlarmReport>") << std::endl;
    ost << m_indent << _TX("  <MachineID xsi:type=\"xsd:integer\">")
                    << m_devid << _TX("</MachineID>") << std::endl;
    ost << m_indent << _TX("  <ErrorCode xsi:type=\"xsd:integer\">")
                    << m_errcode << _TX("</ErrorCode>") << std::endl;
    ost << m_indent << _TX("  <ErrorText xsi:type=\"xsd:string\">")
                    << m_errtext << _TX("</ErrorText>") << std::endl;
    ost << m_indent << _TX("  <AlarmID xsi:type=\"xsd:integer\">")
                    << m_alid << _TX("</AlarmID>") << std::endl;
    ost << m_indent << _TX("  <AlarmState xsi:type=\"xsd:unsignedByte\">")
                    << ((m_alstate) ? 1 : 0) << _TX("</AlarmState>")
                    << std::endl;
    ost << m_indent << _TX("  <AlarmText xsi:type=\"xsd:string\">")
                    << m_altx << _TX("</AlarmText>") << std::endl;
    ost << m_indent << _TX("  <AlarmCategory xsi:type=\"xsd:unsignedByte\">")
                    << m_alcd << _TX("</AlarmCategory>")
                    << std::endl;
    ost << m_indent << _TX("</AlarmReport>") << std::endl;
    outstr = ost.str();
    return (int)outstr.size();
}

} }  // *jyugem::cell*
