// $Id$

//=============================================================================
/**
 *  @file    event_report_message.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#define BEE_BUILD_DLL

#include "jyugem/cell/host_message.h"
#include <sstream>

namespace jyugem { namespace cell
{

void event_report_message::append(const any_item& mbr)
{
    TRACE_FUNCTION(TRL_LOW, "event_report_message::append");

    if (mbr.name() == "EVENT_ID")
    {
        m_ceid = mbr.m_value.toString();
    }
    else if (mbr.name() == "FILE")
    {
        m_filename = mbr.m_value.toString();
    }
    this->report_message::append(mbr);
}


int event_report_message::toVfei(std::string& outstr)
{
    BCHAR buf[256];

    outstr = _TX("CMD/A=\"EVENT_REPORT\" MID/A=\"");
    outstr += m_devid;
    outstr += _TX("\" MTY/A=\"E\" ");
    _stprintf(buf, _TX("ECD/U4=%u ETX/A=\"%s\""), m_errcode,
                                                  m_errtext.c_str());
    outstr += buf;
    outstr += _TX("EVENT_ID/A=\"");
    outstr += m_ceid;
    outstr += _TX("\" ");
    if (m_filename.size() > 0)
    {
        outstr += _TX("FILE/A=\"");
        outstr += m_filename;
        outstr += _TX("\" ");
    }
    if (m_reports.size() > 0)
    {
        outstr += m_reports;
    }
    return (int)outstr.size();
}

int event_report_message::toXml(std::string& outstr)
{
    std::ostringstream ost;
    ost << m_indent << _TX("<EventReport>") << std::endl;
    ost << m_indent << _TX("  <MachineID xsi:type=\"xsd:integer\">")
                    << m_devid << _TX("</MachineID>") << std::endl;
    ost << m_indent << _TX("  <ErrorCode xsi:type=\"xsd:integer\">")
                    << m_errcode << _TX("</ErrorCode>") << std::endl;
    ost << m_indent << _TX("  <ErrorText xsi:type=\"xsd:string\">")
                    << m_errtext << _TX("</ErrorText>") << std::endl;
    ost << m_indent << _TX("  <EventID xsi:type=\"xsd:integer\">")
                    << m_ceid << _TX("</EventID>") << std::endl;
    if (m_filename.size() > 0)
    {
        ost << m_indent << _TX("  <File xsi:type=\"xsd:anyURI\">")
                        << m_filename << _TX("</File>") << std::endl;
    }
    if (m_reports.size() > 0)
    {
        ost << m_reports;
    }
    ost << m_indent << _TX("</EventReport>") << std::endl;
    outstr = ost.str();
    return (int)outstr.size();
}

} }  // *jyugem::cell*
