/* $Id: ResponseMaker.java,v 1.5 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    ResponseMaker.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;
import java.lang.*;
import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;

import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

public class ResponseMaker extends Hashtable {

    // Constructor
    public ResponseMaker() {}

    // Read message file that is formatted xml
    public int open(XmlMessage concreteMessage) {
        String sfname;
        String primary;
        MessageMaker maker;

        Iterator iter = concreteMessage.values().iterator();
        while (iter.hasNext()) {
            Node msgroot = (Node)iter.next();
            NamedNodeMap namedmap = msgroot.getAttributes();
            sfname = namedmap.getNamedItem("sf").getNodeValue();
            Node nameNode = namedmap.getNamedItem("name");
            String labelName = null;
            if (nameNode != null) {
                labelName = nameNode.getNodeValue();
            }
            int num = SECSMessage.toStreamNumber(sfname);
            if ((num & 1) == 0) {
                if (sfname.equals("S2F18")) {
                    maker = new SECSResponse.S2F18();
                    primary = "S2F17";
                } else if (sfname.equals("S1F2") || sfname.equals("S1F14")) {
                    String msgName = sfname + "_HOST";  // SmmFnn_HOST
                    if (SECSConfigurator.m_equipment && labelName == null) {
                        primary = SECSMessage.toStreamName(num - 1);
                        maker = new SECSResponse(sfname, concreteMessage);
                    } else if ((! SECSConfigurator.m_equipment) &&  // Check host side
                               (labelName != null && labelName.equals(msgName))) {
                        primary = SECSMessage.toStreamName(num - 1);
                        maker = new SECSResponse(labelName, concreteMessage);
                    } else {
                        continue;
                    }
                } else {
                    primary = SECSMessage.toStreamName(num - 1);
                    maker = new SECSResponse(sfname, concreteMessage);
                }
                put(primary, maker);
            }
        }
        return 0;
    }

    //
    // Get reply message by the primary one.
    //
    public SECSMessage response(SECSMessage msg) {
        SECSMessage reply;
        if (msg.needReply() && msg.isPrimary())
        {
            MessageMaker respmaker = (MessageMaker)get(msg.name());
            if (respmaker == null) {
                return null;
            }
            reply = respmaker.make(msg);
            if (reply == null) {
                return null;
            }
            reply.transaction(msg.transaction());
            return reply;
        }
        return null;
    }

}

