// $Id: BS2JavaDevice.h,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2JavaDevice.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BS2JAVADEVICE_H
#define BS2JAVADEVICE_H

#include "BS2Device.h"
#include "BS2JavaInterp.h"
#include "BS2Message.h"

// Forward declaration
class BS2State;
class BS2StateTable;
class BS2JavaDevice;

//-----------------------------------------------------------------------------
//
// Delay Time handler for Java Management class
//
//-----------------------------------------------------------------------------
#define INIT_TIMERID            -1
#define ERROR_TIMERID           -1

class JavaDelayHandler : public ACE_Handler
{
public:
    JavaDelayHandler() : m_eventName(_TX("JYUSECS")) {}

    virtual void handle_time_out(const ACE_Time_Value &tv, const void * arg);

private:
    string      m_eventName;
};


//-----------------------------------------------------------------------------
//
// SECS Device Manager for Java
//
//-----------------------------------------------------------------------------
class BS2JavaDevice: public MT_Task
{
public:
    BS2JavaDevice(BCHAR * name);
    ~BS2JavaDevice() { }

    virtual int open(void * = 0);
    virtual int close(int = 0);
    virtual int svc(void);

    int   init(JNIEnv * jenv);

    void  device(BS2Device * device) { m_device = device; }
    BS2Device * device() const       { return m_device; }
    BS2Driver * getDriver() const    { return m_device->getDriver(); }
    void  name(const BCHAR * s)      { m_name = s; }
    const string& name() const       { return m_name; }
    const BCHAR * charName() const   { return m_name.c_str(); }
    long  timerId() const      { return m_tmid; }
    void  timerId(long id)     { m_tmid = id; }
    UINT  logmask() const      { return m_logmask; }
    void  logmask(UINT bits)   { m_logmask = bits; }

    int   stopLoop();                      // terminate thread
    int   send(BS2Message * msg);
    BS2Message * receive();

    static BS2JavaDevice * instance();

protected:
    int startTimer(long sec);
    int cancelTimer();
    int queue(BS2Message * msg);
    BS2Message * dequeue();

//
protected:
    string m_name;
    UINT   m_logmask;
    long   m_tmid;
    BS2Device *      m_device;
    ACE_Time_Value   m_tv;            // event watching time in thread
    JavaDelayHandler m_timer;

    ACE_Auto_Event   m_received;      // synchronized for request
    ACE_Thread_Mutex m_lock;
    BS2MessageQueue  m_queue;

    JNIEnv * m_jenv;
};

#endif
