// $Id: JSBinary.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSBinary.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSBinary.h"

static const char * _className = "java/lang/Byte";

// initialize
void JSBinary::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSBinary::init");

    initClass(jenv, itemClass);

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = jenv->GetMethodID(m_class, "byteValue", "()B");
    ASSERT_METHODID(m_vget, "byteValue", "()B");

    m_new = m_jenv->GetMethodID(m_class, "<init>", "(B)V");
    ASSERT_METHODID(m_new, "<init>", "(B)V");

    m_item = m_jenv->GetMethodID(itemClass, "<init>",
                                            "(Ljava/lang/String;[B)V");
    ASSERT_METHODID(m_item, "<init>", "(Ljava/lang/String;[B)V");
}

// secs value to atom object
jobject JSBinary::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSBinary::toObj");
    BS2Binary * bin = reinterpret_cast<BS2Binary *>(atom);
    int size = bin->size();
    jbyteArray bytes = m_jenv->NewByteArray(size);
    m_jenv->SetByteArrayRegion(bytes, 0, size, (jbyte *)bin->value());

    jobject obj = m_jenv->NewObject(m_class, m_new, bytes);
    return obj;
}

// secs value to item object
jobject JSBinary::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSBinary::toItemObj");

    BS2Binary * bin = reinterpret_cast<BS2Binary *>(atom);
    int size = bin->size();
    jbyteArray bytes = m_jenv->NewByteArray(size);
    m_jenv->SetByteArrayRegion(bytes, 0, size, (jbyte *)bin->value());
    return m_jenv->NewObject(m_itemClass, m_item, itemName, bytes);
}

// jobject to secs value
BS2Atom * JSBinary::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSBinary::toAtom");
    BS2Atom * atom;
    if (valObj != NULL)
    {
        jobjectArray bytes = (jobjectArray)valObj;
        int          byteq = m_jenv->GetArrayLength(bytes);
        BYTE * bytebuf = new BYTE[byteq];
        for (int i = 0; i < byteq; i++)
        {
            jobject byteObj = m_jenv->GetObjectArrayElement(bytes, i);
            if (m_jenv->IsInstanceOf(byteObj, m_class))
            {
                *(bytebuf + i) = m_jenv->CallByteMethod(byteObj, m_vget);
            }
            else
            {
                TRACE_ERROR(("Parse error (\"byte\" other object found)\n"));
                delete[] bytebuf;
                return NULL;
            }
        }
        atom = new BS2Binary(bytebuf, byteq);
        delete[] bytebuf;
    }
    else
    {
        atom = new BS2Binary();
    }
    return atom;
}

