// $Id: JSFloat8.h,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSFloat8.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JSFLOAT8_H
#define JSFLOAT8_H

#include "BS2Float8.h"
#include "JSAtom.h"

class JSFloat8 : public JSAtom
{
public:
    JSFloat8() : JSAtom() {}
    virtual ~JSFloat8() {}

    void init(JNIEnv * jenv, jclass itemClass);

    // secs value to atom object
    virtual jobject toObj(BS2Atom * atom);

    // secs value to item object
    virtual jobject toItemObj(BS2Atom * atom, jstring itemName);

    // jobject to atom
    virtual BS2Atom * toAtom(jobject valObj);
    virtual BS2Atom * toArray(jobject valObj);
    virtual int       toList(jobject listObj, BS2List * listAtom);

protected:

};

#endif
