// $Id: JSInt2.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSInt2.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSInt2.h"
#include "BS2Array.h"
#include "BS2List.h"

static const char * _className = "java/lang/Short";

void JSInt2::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt2::init");

    initClass(jenv, itemClass);

    m_class = m_jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(m_class, "shortValue", "()S");
    ASSERT_METHODID(m_vget, "shortValue", "()S");

    m_new = m_jenv->GetMethodID(m_class, "<init>", "(S)V");
    ASSERT_METHODID(m_new, "<init>", "(S)V");

    m_item = m_jenv->GetMethodID(itemClass, "<init>",
                                            "(Ljava/lang/String;S)V");
    ASSERT_METHODID(m_item, "<init>", "(Ljava/lang/String;S)V");

    m_array= jenv->GetMethodID(itemClass, "<init>",
                                          "(Ljava/lang/String;[S)V");
    ASSERT_METHODID(m_array, "<init>", "(Ljava/lang/String;[S)V");
}

// secs value to atom object
jobject JSInt2::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt2::toObj");
    jobject obj = m_jenv->NewObject(m_class, m_new,
                                    reinterpret_cast<BS2Int2 *>(atom)->value());
    return obj;
}

// secs value to item object
jobject JSInt2::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt2::toItemObj");
    jobject obj;
    int format = atom->format();
    if (format & ATOM_ARRAY)
    {
        BS2Int2Array * arrayAtom = reinterpret_cast<BS2Int2Array *>(atom);
        int     len = arrayAtom->count();
        short * values = arrayAtom->value();

        jshortArray array =  m_jenv->NewShortArray(len);
        BEEAssert(array != NULL);
        for (int i = 0; i < len; i++)
        {
            jshort val = *(values + i);
            m_jenv->SetShortArrayRegion(array, (jsize)i, 1, &val);
        }
        obj = m_jenv->NewObject(m_itemClass, m_array, itemName, array);
        m_jenv->ReleaseShortArrayElements(array, NULL, JNI_ABORT); // !?
    }
    else
    {
        obj = m_jenv->NewObject(m_itemClass, m_item, itemName,
                                reinterpret_cast<BS2Int2 *>(atom)->value());
    }
    return obj;
}

// jobject to secs value
BS2Atom * JSInt2::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt2::toAtom");

    BS2Atom * atom;
    if (valObj != NULL)
    {
        jshort shortval = m_jenv->CallShortMethod(valObj, m_vget);
        atom = new BS2Int2(shortval);
    }
    else
    {
        atom = new BS2Int2();
    }
    return atom;
}

// jobject to secs array
BS2Atom * JSInt2::toArray(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt2::toArray");

    if (valObj == NULL)
    {
        TRACE_ERROR(("Empty member object\n"));
        return NULL;
    }

    jobjectArray array = (jobjectArray)valObj;
    jsize len      = m_jenv->GetArrayLength(array);
    short * values = new short[len];
    for (int i = 0; i < len; i++)
    {
        jobject obj = m_jenv->GetObjectArrayElement(array, i);
        jshort  val = m_jenv->CallShortMethod(obj, m_vget);
        *(values + i) = (short)val;
    }
    BS2Int2Array * atom = new BS2Int2Array();
    atom->add(values, len);
    delete[] values;

    return atom;
}

// jobject to secs list
int JSInt2::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt2::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jobject mbrObj = m_jenv->CallObjectMethod(valObj, m_listGet, i);
        jshort val = m_jenv->CallShortMethod(mbrObj, m_vget);
        BS2Atom * atom = new BS2Int2(val);
        listAtom->add(*atom);
        delete atom;
    }
    return 0;
}

