// $Id: JSList.cpp,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSList.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSList.h"

static const char * _className = "java/util/ArrayList";

void JSList::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSList::init");

    initClass(jenv, itemClass);

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_new = jenv->GetMethodID(m_class, "<init>", "()V");
    ASSERT_METHODID(m_class, "<init>", "()V");

    m_add = jenv->GetMethodID(m_class, "add", "(Ljava/lang/Object;)Z");
    ASSERT_METHODID(m_add, "add", "(Ljava/lang/Object;)Z");

    m_item = jenv->GetMethodID(itemClass, "<init>",
                               "(Ljava/lang/String;Ljava/util/ArrayList;)V");
    ASSERT_METHODID(m_item, "<init>",
                            "(Ljava/lang/String;Ljava/util/ArrayList;)V");

}

// secs value to atom object
jobject JSList::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSList::toObj");
    jobject listObj = m_jenv->NewObject(m_class, m_new);
    BS2List * listAtom = reinterpret_cast<BS2List *>(atom);
    BS2Atoms::iterator iter = listAtom->getList().begin();
    for ( ; iter != listAtom->getList().end(); iter++)
    {
        BS2Atom * member = *iter;
        int format = member->format();
        //jobject atomObj = createListAtomToObject(jenv, (BS2List *)atom);

        jobject atomObj = JSAtom::instance(format)->toObj(member);
        if (atomObj == NULL)
        {
            TRACE_ERROR(("Illegal memober atom.\n"));
            return NULL;
        }
        jboolean result = m_jenv->CallBooleanMethod(listObj, m_add, atomObj);
        if (! result)
        {
            TRACE_ERROR(("Can't add object.\n"));
            return NULL;
        }
    }
    return listObj;
}

// secs value to item object
jobject JSList::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSList::toItemObj");

    jobject listObj = this->toObj(atom);
    if (listObj == NULL)
    {
        return NULL;
    }
    return m_jenv->NewObject(m_itemClass, m_item, itemName, listObj);
}

// jobject to secs value
BS2Atom * JSList::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_MIDDLE, "JSList::toAtom");
    BS2List * listAtom = new BS2List();
    if (valObj != NULL)
    {
        jint mbrtype = m_jenv->GetIntField(valObj, m_typeFld);

        // jint len = m_jenv->CallIntMethod(valObj, m_listSize);
        JSAtom * mbr = JSAtom::instance(mbrtype);
        if (mbr != NULL)
        {
            int result = mbr->toList(valObj, listAtom);
            if (result < 0)
            {
                return NULL;
            }
        }
        else
        {
            TRACE_ERROR(("Illegal array type(%d).\n", mbrtype));
            return NULL;
        }
    }

    return listAtom;
}

