// $Id: JSListItem.cpp,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSListItem.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSListItem.h"
#include "JSItem.h"

static char * _className = CLASSPATH "SECSList";
static char * _itemSignature = "(L" CLASSPATH "SECSItem;)V";
static char * _listSignature = "(L" CLASSPATH "SECSList;)V";

static JSListItem _list;

// Global access method
JSListItem * JSListItem::instance()
{
    return &_list;
}

void JSListItem::init(JNIEnv * jenv)
{
    TRACE_FUNCTION(TRL_LOW, "JSListItem::init");
    m_jenv = jenv;

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_new = jenv->GetMethodID(m_class, "<init>", "()V");
    ASSERT_METHODID(m_new, "<init>", "()V");

    m_setList = jenv->GetMethodID(m_class, "set", _listSignature);
    ASSERT_METHODID(m_setList, "set", _listSignature);

    m_setItem = jenv->GetMethodID(m_class, "add", _itemSignature);
    ASSERT_METHODID(m_setItem, "add", _itemSignature);

    m_addItem = jenv->GetMethodID(m_class, "add", _itemSignature);
    ASSERT_METHODID(m_addItem, "add", _itemSignature);

    m_size = jenv->GetMethodID(m_class, "getChildCount", "()I");
    ASSERT_METHODID(m_size, "getChildCount", "()I");

    m_at = jenv->GetMethodID(m_class, "getChildAt",
                                        "(I)Ljavax/swing/tree/TreeNode;");
    ASSERT_METHODID(m_at, "getChildAt", "(I)Ljavax/swing/tree/TreeNode;");

    m_userFld = jenv->GetFieldID(m_class, "userObject", "Ljava/lang/Object;");
    ASSERT_FIELDID(m_userFld, "userObject", "Ljava/lang/Object;");
}

//
// --- object ---
//
// Is the object list
bool JSListItem::isList(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSListItem::isList");
    jboolean result = m_jenv->IsInstanceOf(valObj, m_class);
    return ((result) ? true : false);
}

// New list object
jobject JSListItem::makeListObj()
{
    TRACE_FUNCTION(TRL_LOW, "JSListItem::makeListObj");
    jobject listObj = m_jenv->NewObject(m_class, m_new);
    return listObj;
}

// Parse secs item list
int JSListItem::toItemObj(BS2ListItem * listItem, jobject listObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSListItem::toItemObj");
    int result;
    BS2Items::iterator iter = listItem->items().begin();
    for ( ; iter != listItem->items().end(); iter++)
    {
        jobject itemObj;
        BS2Item * item = *iter;
        if (item->isList() && item->isListItem())
        {   // Create node object for List item.
            jobject childList = JSListItem::instance()->makeListObj();
            result = JSListItem::instance()->toItemObj(reinterpret_cast<BS2ListItem *>(item),
                                                   childList);
            if (result < 0)
            {
                return result;
            }
            itemObj = childList;
        }
        else
        {   // Create Item object
            itemObj = JSItem::instance()->toItemObj(item);
            if (itemObj == NULL)
            {
                return -1;
            }
        }
        // Insert java object in node object
        m_jenv->CallVoidMethod(listObj, m_addItem, itemObj);
    }
    return 0;
}

// Parse object list
int JSListItem::toItem(jobject listObj, BS2ListItem * listItem)
{
    TRACE_FUNCTION(TRL_LOW, "JSListItem::toItem");
    jint size = m_jenv->CallIntMethod(listObj, m_size);
    // As size is 0, list is empty.

    // Make member item
    for (int i = 0; i < size; i++)
    {
        jobject itemObj = m_jenv->CallObjectMethod(listObj, m_at, i);
        if (itemObj == NULL)
        {
            TRACE_ERROR(("Member object not found (%d)\n", i));
            return -1;
        }

        jobject member = m_jenv->GetObjectField(itemObj, m_userFld);
        if (member == NULL)
        {   // List
            BS2ListItem * childList = new BS2ListItem;
            listItem->add(childList);
            if (JSListItem::instance()->toItem(itemObj, childList) < 0)
            {
                return -1;
            }
        }
        else
        {   // Item
            BS2Item * item = JSItem::instance()->toItem(member);
            if (item == NULL)
            {
                return -1;
            }
            listItem->add(item);
        }
    }
    return 0;
}

