// $Id: JSMessage.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSMessage.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSMessage.h"
#include "JSListItem.h"
#include "JSItem.h"

static char * _className = CLASSPATH  "SECSMessage";
static char * _setListSignature = "(L" CLASSPATH "SECSList;)V";
static char * _setItemSignature = "(L" CLASSPATH "SECSItem;)V";

static JSMessage _message;

//
JSMessage * JSMessage::instance()
{
    return &_message;
}

// Initialize class, method and field which is attributes of SECSMessage
void JSMessage::init(JNIEnv * jenv)
{
    TRACE_FUNCTION(TRL_LOW, "JSMessage::init");
    m_jenv = jenv;

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_new = jenv->GetMethodID(m_class, "<init>", "(Ljava/lang/String;ZI)V");
    ASSERT_METHODID(m_new, "<init>", "(Ljava/lang/String;ZI)V");

    m_size = jenv->GetMethodID(m_class, "getChildCount", "()I");
    ASSERT_METHODID(m_size, "getChildCount", "()V");

    m_at = jenv->GetMethodID(m_class, "getChildAt",
                                      "(I)Ljavax/swing/tree/TreeNode;");
    ASSERT_METHODID(m_at, "getChildAt", "(I)Ljavax/swing/tree/TreeNode;");

    m_setList = jenv->GetMethodID(m_class, "set",
                                           _setListSignature);
    ASSERT_METHODID(m_setList, "set", _setListSignature);

    m_setItem = jenv->GetMethodID(m_class, "set",
                                           _setItemSignature);
    ASSERT_METHODID(m_setItem, "set", _setItemSignature);

    m_sfnumFld = jenv->GetFieldID(m_class, "m_stnum", "I");
    ASSERT_FIELDID(m_sfnumFld, "m_stnum", "I");

    m_waitFld = jenv->GetFieldID(m_class, "m_wait", "Z");
    ASSERT_FIELDID(m_waitFld, "m_wait", "Z");

    m_transFld = jenv->GetFieldID(m_class, "m_transactionNum", "I");
    ASSERT_FIELDID(m_transFld, "m_transactionNum", "I");

    m_userFld = jenv->GetFieldID(m_class, "userObject", "Ljava/lang/Object;");
    ASSERT_FIELDID(m_userFld, "userObject", "Ljava/lang/Object;");

}

//
// --- object ---
//

// secs value to item object
jobject JSMessage::toItemObj(BS2Message * msg)
{
    TRACE_FUNCTION(TRL_LOW, "JSMessage::toItemObj");
    jobject msgObj;
    jvalue args[3];
    args[0].l = m_jenv->NewStringUTF(msg->charName());
    args[1].z = msg->reply();
    args[2].i = msg->transNum();     // transaction number
    if (msg == NULL)
    {
        TRACE_ERROR((_TX("Message is null\n")));
        return NULL;
    }
    if (msg->itemCount() < 0)
    {   // Illegal message format
        TRACE_ERROR((_TX("Node is not exist.\n")));
        return NULL;
    }
    msgObj = m_jenv->NewObjectA(m_class, m_new, args);

    BS2ItemList::iterator iter = msg->items().begin();
    for ( ; iter != msg->items().end(); ++iter)
    {
        BS2Item * item = *iter;
        if (item->isList())
        {
            // set listNode
            jobject listObj = JSListItem::instance()->makeListObj();
            m_jenv->CallVoidMethod(msgObj, m_setList, listObj);

            // Traverse list member
            int ret = JSListItem::instance()->toItemObj(
                              reinterpret_cast<BS2ListItem *>(item), listObj);
            if (ret < 0)
            {
                break;
            }
        }
        else
        {    // set item
            jobject itemObj = JSItem::instance()->toItemObj(item);
            if (itemObj == NULL)
            {
                break;
            }
            m_jenv->CallVoidMethod(msgObj, m_setItem, itemObj);
        }
    }

    return msgObj;
}

// jobject to message
BS2Message * JSMessage::toMessage(jobject msgObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSMessage::toMessage");

    int  stnum = m_jenv->GetIntField(msgObj, m_sfnumFld);
    bool waitBit = (m_jenv->GetBooleanField(msgObj, m_waitFld)) ? true : false;
    int  transNum = m_jenv->GetIntField(msgObj, m_transFld);

    BS2Message * msg = BS2Message::factory(stnum);
    msg->wait(waitBit);
    msg->transNum(transNum);

    int size = m_jenv->CallIntMethod(msgObj, m_size);
    // As size is 0, message is header only

    // Make root item
    jobject itemObj = m_jenv->GetObjectField(msgObj, m_userFld);
    if (itemObj != NULL)
    {   // Exist root item
        BS2Item * item = JSItem::instance()->toItem(itemObj);
        if (item == NULL)
        {
            delete msg;
            return NULL;
        }
        msg->add(item);
    }
    else if (size == 1)
    {   // Root item is list
        jobject mbrList = m_jenv->CallObjectMethod(msgObj, m_at, 0);
        if (JSListItem::instance()->isList(mbrList))
        {   // List
            BS2ListItem * rootList = new BS2ListItem;
            msg->add(rootList);
            int result = JSListItem::instance()->toItem(mbrList, rootList);
            if (result < 0)
            {
                delete msg;
                return NULL;
            }
        }
    }
    return msg;
}

