#!/usr/bin/env ruby
#
# ==========================================================
# kagiPDF
# ==========================================================
# :Author: SAKIMA Kimihisa
# :Contact: sakima at hooktail.org
# :Date: $Date: 2007/02/24 14:46:57 $
# :Revision: $Revision: 1.7 $
#
# 
# ====
#
#   ̾⡼
#     kagipdf.rb [OPTION] infile
#
#   ե륿⡼
#     kagipdf.rb [OPTION] < stream
#     stream | kagipdf.rb [OPTION]
#
# ץ
# ==========
#
#   -o <string>
#   -k <type>
#   -q
#   -c
#   -l
#   --notex
#   --nopdf
#   --style <type>
#   --strict
#   --help
#   --version
#
#--
require 'nkf'
require 'iconv'
require 'optparse'


# ==========================================================
# ץ
# ==========================================================
opt = OptionParser.new
Version = "0.4.1 (2007-02-24)"
OPTS = {}
# latexʸɻ
opt.on('-k VAL', 'Specify the text encoding for output.'){|v|
  OPTS[:k] = v
}
# ե̾
opt.on('-o VAL', 'Place output in file VAL.'){|v|
  OPTS[:o] = v
}
# Quiet operation
opt.on('-q', 'Do not report any system messages.'){|v|
  OPTS[:q] = v
}
# pdfեΤ߻ĤtexdviեϺ
opt.on('-c', 'Make PDF file only.'){|v|
  OPTS[:c] = v
}
# ֥ե򤹤٤ƻĤ
opt.on('-l', 'Leese All.'){|v|
  OPTS[:l] = v
}
# latexѥ򤷤ʤ
opt.on('--notex', 'Do not platex compileing.'){|v|
  OPTS[:notex] = v
}
# pdfʤ
opt.on('--nopdf', 'Do not generate PDF file.'){|v|
  OPTS[:nopdf] = v
}
# epsʤ
opt.on('--noeps', 'Do not generate EPS file from JPEG, PNG, GIF images.'){|v|
  OPTS[:noeps] = v
}
# strict mode
opt.on('--strict', 'Strict reStructuredText mode.'){|v|
  OPTS[:strict] = v
}
# 
OPTS[:style] = "hooktail"  # ǥե
opt.on('--style VAL'){|v|
  OPTS[:style] = v
}
opt.parse!(ARGV)


# ==========================================================
# 
# ==========================================================
begin
  if FileTest::symlink?(__FILE__) then
    org_path = File::dirname(File::readlink(__FILE__))
  else
    org_path = File::dirname(__FILE__)
  end
  $:.unshift(org_path.untaint)
  require 'extension'
  require 'fairlatex'
  if $stdin.tty?
    # ɸϤüξ
    in_file  = ARGV.shift
    contents = open(in_file){ |io| io.read }
  else
    # ѥס쥯Ȥμ¹
    in_file  = "kagipdf_default.txt"  # ѥե̾򥻥å
    contents = $stdin.read            # ɸϤɤ߼
    OPTS[:q] = true                   # Quiet operation
#    OPTS[:c] = true                   # Clean operation
  end
  in_file  = OPTS[:o] if OPTS[:o]  # ե̾ꥪץ󤬤
  out_file = File.basename(in_file, ".*")  # ĥҤ
  out_file_tmp  = out_file + ".tmp"
  out_file_reST = out_file + ".reST"
  out_file_tex  = out_file + ".tex"
  out_file_pdf  = out_file + ".pdf"
rescue Exception
  print "[error] File not found, exit.\n"
  exit 1
end

# ϥեʸɤEUC-JPˤ
#contents.gsub!(/\r/, "")  # ԥCR
File.open(out_file_tmp, "w"){ |file| file.write contents}
#system("lv -Oej #{out_file_tmp} > tmp$$; mv tmp$$ #{out_file_tmp}")
system("nkf --unix #{out_file_tmp} > tmp$$; mv tmp$$ #{out_file_tmp}")
contents = File.open(out_file_tmp){ |io| io.read }

# -q ץ󤬤Хޥɤɸϡɸ२顼ΤƤ
cmd_stream = " > /dev/null 2>&1" if OPTS[:q]


# ==========================================================
# ᥤ
# ==========================================================

# äݳĥν
unless OPTS[:strict]
  contents = inline_math(contents)
  contents = display_math(contents)
  contents = figure(contents) unless OPTS[:noeps]
  contents = atat(contents)
  contents = etc(contents, OPTS[:style])
end

# ̩reStructuredTextȤƥե
File.open(out_file_reST, "w"){ |file|
  file.write contents
}


# rst2latex.py¹
# ==================
rstopt1 = "-o utf-8 --use-latex-docinfo --use-latex-footnotes"
rstopt2 = "--use-latex-toc" unless OPTS[:style] == "hooktail"
rstopt3 = "--hyperlink-color black" if OPTS[:style] == "thesis"
# UTF-8ˤrst2latex.pyˤɬפ뤿ᡤlv򤫤ޤƤ
system("lv -Ou8 #{out_file_reST} > tmp$$;
        rst2latex.py #{rstopt1} #{rstopt2} #{rstopt3} tmp$$ #{out_file_tex} #{cmd_stream};
        lv -Oej #{out_file_tex} > tmp$$;
        mv tmp$$ #{out_file_tex}"
)


# latex
texsource = open(out_file_tex){ |io| io.read }
texsource = documentclass(texsource, OPTS[:style])  # 饹
texsource = preamble(texsource, OPTS[:style])       # ץꥢ֥
texsource = textitle(texsource, OPTS[:style])       # ȥ
texsource = texbody(texsource, OPTS[:style])        # ʸ

# latexʸɤλ
# ǥեȤeuc-jpcygwinξShift_JISˡץͥ补
if    OPTS[:k] == "s"
  texsource = NKF.nkf("-s -m0 -c", texsource)
elsif OPTS[:k] == "e"
  texsource = NKF.nkf("-e -m0 -d", texsource)
elsif OPTS[:k] == "u"
  texsource = Iconv.iconv("UTF-8", "eucJP", texsource)
elsif RUBY_PLATFORM =~ /cygwin/
  texsource = NKF.nkf("-s -m0 -c", texsource)
end

# latexե
File.open(out_file_tex, "w"){ |file|
  file.write texsource
}


# platex¹
# ============
unless OPTS[:notex]
  # ѥ2Ϣ³
  2.times{
    # 10Ķ⤷ϥե륵2048ХĶǽǤڤ
    # platexѥϥ顼ФƤǻߤʤ
    system("ulimit -t 10 -f 2048 #{cmd_stream};
            platex -interaction=nonstopmode #{out_file_tex} #{cmd_stream}"
    )
  }
end


# dvipdfmx¹
# ==============
unless OPTS[:nopdf] || OPTS[:notex]
  system("dvipdfmx #{out_file} #{cmd_stream}")
end


# פʤե뤬оä
unwanted = [".tmp", ".aux", ".log", ".out", ".reST", ".toc"]
if OPTS[:c]
  unwanted.push(".tex").push(".dvi")
elsif OPTS[:l]
  unwanted.clear
end
unwanted.each {|ext|
  rmfile = out_file + ext
  File.delete(rmfile) if FileTest.exist?(rmfile)
}
