/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import java.util.Hashtable;
import org.apache.xalan.stree.CDATASectionImpl;
import org.apache.xalan.stree.CommentImpl;
import org.apache.xalan.stree.DocImpl;
import org.apache.xalan.stree.DocumentFragmentImpl;
import org.apache.xalan.stree.DocumentTypeImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.ElementImplWithNS;
import org.apache.xalan.stree.ProcessingInstructionImpl;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.stree.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends DocImpl {
    DocumentTypeImpl m_docType;
    ElementImpl m_docElement;
    Hashtable m_idAttributes = new Hashtable();

    DocumentImpl() {
        this.setDoc(this);
    }

    public DocumentImpl(int charBufSize) {
        super(charBufSize);
        this.setDoc(this);
    }

    DocumentImpl(SourceTreeHandler sth) {
        this.setDoc(this);
        this.m_sourceTreeHandler = sth;
    }

    DocumentImpl(DocumentType doctype) {
        this.setDoc(this);
        if (doctype != null) {
            this.m_docType = (DocumentTypeImpl)doctype;
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.getNodeType() != 11) {
            short type = newChild.getNodeType();
            if (type == 1) {
                if (this.m_docElement != null) {
                    throw new DOMException(3, "DOM006 Hierarchy request error");
                }
                this.m_docElement = (ElementImpl)newChild;
            } else if (type == 10) {
                this.m_docType = (DocumentTypeImpl)newChild;
            }
        }
        return super.appendChild(newChild);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return super.createAttributeNS(namespaceURI, qualifiedName);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl();
    }

    public Element createElement(String tagName) throws DOMException {
        return new ElementImpl(this, tagName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new ElementImplWithNS(this, namespaceURI, qualifiedName);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public DocumentType getDoctype() {
        return this.m_docType;
    }

    public Element getDocumentElement() {
        return this.m_docElement;
    }

    public Element getElementById(String elementId) {
        Element elem = (Element)this.m_idAttributes.get(elementId);
        if (elem == null && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        elem = (Element)this.m_idAttributes.get(elementId);
                        if (elem == null) continue;
                        Element element = elem;
                        Object var5_5 = null;
                        return element;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
            elem = (Element)this.m_idAttributes.get(elementId);
        }
        return elem;
    }

    public Hashtable getIDAttributes() {
        return this.m_idAttributes;
    }

    public String getLocalName() {
        return "#document";
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return super.importNode(importedNode, deep);
    }

    public void setDoctype(DocumentType docType) {
        this.m_docType = (DocumentTypeImpl)docType;
    }

    public void setIDAttribute(String id, Element elem) {
        this.m_idAttributes.put(id, elem);
    }
}

