/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import kamicup.publication.webmanager.projects.Project;
import kamicup.publication.webmanager.projects.Rss;
import kamicup.publication.webmanager.projects.Update;
import kamicup.publication.webmanager.rss10.Channel;
import kamicup.publication.webmanager.rss10.Creator;
import kamicup.publication.webmanager.rss10.Date2;
import kamicup.publication.webmanager.rss10.Item;
import kamicup.publication.webmanager.rss10.Items;
import kamicup.publication.webmanager.rss10.Li;
import kamicup.publication.webmanager.rss10.RDF;
import kamicup.publication.webmanager.rss10.Seq;
import kamicup.relaxer.utils.v1_1b.RNSContext;
import kamicup.xml.dom.XMLWriter;
import org.w3c.dom.Document;

public class Converter {
    public static File extract(Project project) throws ParserConfigurationException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        RDF rdf = Converter.makeRDF(project);
        File fRss = new File(project.getRss().getFile());
        if (!fRss.getAbsolutePath().equals(fRss.getPath())) {
            File fPrj = new File(project.getLocal());
            fRss = new File(fPrj, project.getRss().getFile());
        }
        RNSContext rNSContext = rdf.rGetRNSContext();
        rNSContext.declareNamespace("", "http://purl.org/rss/1.0/");
        rNSContext.declareNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rNSContext.declareNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rNSContext.setPrefix("rdf");
        Document doc = rdf.makeDocument();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fRss), "UTF-8");
        XMLWriter xw = new XMLWriter(writer);
        xw.setEncoding("UTF-8");
        xw.setIndent("yes");
        xw.print(doc);
        ((Writer)writer).close();
        return fRss;
    }

    private static RDF makeRDF(Project project) throws MalformedURLException {
        Rss rss = project.getRss();
        RDF rdf = new RDF();
        rdf.setChannel(Converter.makeChannel(project, project.getAuthor()));
        int i = 0;
        while (i < rss.sizeUpdate()) {
            rdf.addItem(Converter.makeItem(rss.getUpdate(i), project.getAuthor()));
            ++i;
        }
        return rdf;
    }

    private static Item makeItem(Update update, String author) {
        Item item = new Item();
        RNSContext rNSContext = item.rGetRNSContext();
        rNSContext.declareNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        item.setAbout(update.getLink());
        item.setTitle(update.getTitle());
        item.setLink(update.getLink());
        item.setDate(Converter.makeDate2(update.getDate()));
        item.setCreator(Converter.makeCreator(author));
        item.setDescription(update.getDescription());
        return item;
    }

    private static Channel makeChannel(Project project, String author) throws MalformedURLException {
        Rss rss = project.getRss();
        URL uPrj = new URL(project.getUrl());
        URL uRss = new URL(uPrj, rss.getUrl());
        Channel channel = new Channel();
        RNSContext rNSContext = channel.rGetRNSContext();
        rNSContext.declareNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        channel.setAbout(uRss.toExternalForm());
        channel.setTitle(project.getName());
        channel.setLink(project.getUrl());
        channel.setDescription(project.getDescription());
        channel.setDate(Converter.makeDate2(System.currentTimeMillis()));
        channel.setCreator(Converter.makeCreator(author));
        channel.setItems(Converter.makeItems(rss));
        return channel;
    }

    private static Items makeItems(Rss rss) {
        Items items = new Items();
        Seq seq = new Seq();
        int i = 0;
        while (i < rss.sizeUpdate()) {
            Li li = new Li();
            li.setResource(rss.getUpdate(i).getLink());
            seq.addLi(li);
            ++i;
        }
        items.setSeq(seq);
        return items;
    }

    private static Date2 makeDate2(long time) {
        return Converter.makeDate2(new Timestamp(time));
    }

    private static Date2 makeDate2(Timestamp timeStamp) {
        Date2 date2 = new Date2();
        RNSContext rNSContext = date2.rGetRNSContext();
        rNSContext.declareNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rNSContext.setPrefix("dc");
        date2.setContent(timeStamp);
        return date2;
    }

    private static Creator makeCreator(String value) {
        Creator creator = new Creator();
        RNSContext rNSContext = creator.rGetRNSContext();
        rNSContext.declareNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rNSContext.setPrefix("dc");
        creator.setContent(value);
        return creator;
    }
}

