/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.projects;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import kamicup.relaxer.utils.v1_1b.IRNSContainer;
import kamicup.relaxer.utils.v1_1b.IRNode;
import kamicup.relaxer.utils.v1_1b.RNSContext;
import kamicup.relaxer.utils.v1_1b.RStack;
import kamicup.relaxer.utils.v1_1b.UJAXP;
import kamicup.relaxer.utils.v1_1b.URelaxer;
import kamicup.relaxer.utils.v1_1b.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Update
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://kamicup.sourceforge.jp/xmlns/pubman");
    private String title_;
    private String link_;
    private Timestamp date_;
    private String description_;
    private IRNode parentRNode_;

    public Update() {
        this.title_ = "";
        this.link_ = "";
        this.date_ = URelaxer.makeAutoSQLTimestamp();
        this.description_ = "";
    }

    public Update(Update source) {
        this.setup(source);
    }

    public Update(RStack stack) {
        this.setup(stack);
    }

    public Update(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Update(Element element) {
        this.setup(element);
    }

    public Update(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Update(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Update(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Update(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Update(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Update(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Update source) {
        this.setTitle(source.getTitle());
        this.setLink(source.getLink());
        this.setDate(source.getDate());
        this.setDescription(source.getDescription());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.title_ = URelaxer.getAttributePropertyAsString(element, "title");
        this.link_ = URelaxer.getAttributePropertyAsString(element, "link");
        this.date_ = URelaxer.getAttributePropertyAsSQLTimestamp(element, "date");
        this.description_ = URelaxer.getAttributePropertyAsString(element, "description");
    }

    public Object clone() {
        return new Update(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://kamicup.sourceforge.jp/xmlns/pubman", "update");
        this.rNSContext_.setupNamespace(element);
        if (this.title_ != null) {
            URelaxer.setAttributePropertyByString(element, "title", this.title_);
        }
        if (this.link_ != null) {
            URelaxer.setAttributePropertyByString(element, "link", this.link_);
        }
        if (this.date_ != null) {
            URelaxer.setAttributePropertyBySQLTimestamp(element, "date", this.date_);
        }
        if (this.description_ != null) {
            URelaxer.setAttributePropertyByString(element, "description", this.description_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getTitle() {
        return this.title_;
    }

    public final void setTitle(String title) {
        this.title_ = title;
    }

    public final String getLink() {
        return this.link_;
    }

    public final void setLink(String link) {
        this.link_ = link;
    }

    public final Timestamp getDate() {
        return this.date_;
    }

    public final void setDate(Timestamp date) {
        this.date_ = date;
    }

    public final String getDescription() {
        return this.description_;
    }

    public final void setDescription(String description) {
        this.description_ = description;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://kamicup.sourceforge.jp/xmlns/pubman");
        buffer.append("<");
        URelaxer.makeQName(prefix, "update", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.title_ != null) {
            buffer.append(" ");
            buffer.append("title");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTitle())));
            buffer.append("\"");
        }
        if (this.link_ != null) {
            buffer.append(" ");
            buffer.append("link");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLink())));
            buffer.append("\"");
        }
        if (this.date_ != null) {
            buffer.append(" ");
            buffer.append("date");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(this.getDate()));
            buffer.append("\"");
        }
        if (this.description_ != null) {
            buffer.append(" ");
            buffer.append("description");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</");
        URelaxer.makeQName(prefix, "update", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("http://kamicup.sourceforge.jp/xmlns/pubman");
        buffer.write("<");
        URelaxer.makeQName(prefix, "update", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.title_ != null) {
            buffer.write(" ");
            buffer.write("title");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTitle())));
            buffer.write("\"");
        }
        if (this.link_ != null) {
            buffer.write(" ");
            buffer.write("link");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLink())));
            buffer.write("\"");
        }
        if (this.date_ != null) {
            buffer.write(" ");
            buffer.write("date");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(this.getDate()));
            buffer.write("\"");
        }
        if (this.description_ != null) {
            buffer.write(" ");
            buffer.write("description");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</");
        URelaxer.makeQName(prefix, "update", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://kamicup.sourceforge.jp/xmlns/pubman");
        buffer.print("<");
        URelaxer.makeQName(prefix, "update", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.title_ != null) {
            buffer.print(" ");
            buffer.print("title");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTitle())));
            buffer.print("\"");
        }
        if (this.link_ != null) {
            buffer.print(" ");
            buffer.print("link");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLink())));
            buffer.print("\"");
        }
        if (this.date_ != null) {
            buffer.print(" ");
            buffer.print("date");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(this.getDate()));
            buffer.print("\"");
        }
        if (this.description_ != null) {
            buffer.print(" ");
            buffer.print("description");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</");
        URelaxer.makeQName(prefix, "update", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTitleAsString() {
        return URelaxer.getString(this.getTitle());
    }

    public String getLinkAsString() {
        return URelaxer.getString(this.getLink());
    }

    public String getDateAsString() {
        return URelaxer.getString(this.getDate());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public void setTitleByString(String string) {
        this.setTitle(string);
    }

    public void setLinkByString(String string) {
        this.setLink(string);
    }

    public void setDateByString(String string) {
        this.setDate(URelaxer.getSQLTimestamp(string));
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://kamicup.sourceforge.jp/xmlns/pubman", "update")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "title")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "link")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "date")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "description")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Update.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Update.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

