/*
 * Decompiled with CFR 0.152.
 */
package kamicup.xml.dom;

import java.util.StringTokenizer;
import kamicup.xml.dom.MyNodeList;
import kamicup.xml.dom.deprecated.DomTool;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EasyXPath {
    private Node ROOT;

    public EasyXPath(Node node) {
        this.ROOT = node;
    }

    public String getNodeValue(String xpath, int index) {
        Node node = this.getNodes(xpath).item(index);
        try {
            return node.getNodeValue();
        }
        catch (NullPointerException npe) {
            return "";
        }
    }

    public NodeList getNodes(String xpath) {
        Node current = this.ROOT;
        if (xpath.charAt(0) == '/' && this.ROOT.getNodeType() != 9) {
            current = this.ROOT.getOwnerDocument();
            xpath = xpath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(xpath, "/@", true);
        MyNodeList myNodeList = new MyNodeList();
        myNodeList.add(current);
        return this._getNodes(st, myNodeList);
    }

    private NodeList _getNodes(StringTokenizer st, NodeList nodeList) {
        if (!st.hasMoreTokens()) {
            return nodeList;
        }
        String token = st.nextToken();
        NodeList myNodeList = null;
        if (token.equals("/")) {
            myNodeList = nodeList;
        } else if (token.equals("@")) {
            myNodeList = new MyNodeList();
            String attrToken = st.nextToken();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node child;
                Node node = nodeList.item(i);
                NamedNodeMap children = node.getAttributes();
                if (children != null && (child = children.getNamedItem(attrToken)) != null) {
                    ((MyNodeList)myNodeList).add(child);
                }
                ++i;
            }
        } else if (token.equals("..")) {
            myNodeList = new MyNodeList();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                ((MyNodeList)myNodeList).add(node.getParentNode());
                ++i;
            }
        } else {
            if (token.equals("text()")) {
                token = "#text";
            }
            myNodeList = new MyNodeList();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                NodeList children = node.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    if (children.item(j).getNodeName().equals(token)) {
                        ((MyNodeList)myNodeList).add(children.item(j));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this._getNodes(st, myNodeList);
    }

    public static final void main(String[] args) throws Exception {
        if (args.length == 2) {
            Document doc = DomTool.newDocument(args[0]);
            EasyXPath exp = new EasyXPath(doc);
            NodeList userList = exp.getNodes(args[1]);
            int i = 0;
            while (i < userList.getLength()) {
                System.out.println(String.valueOf(i) + ": " + userList.item(i).getNodeValue());
                ++i;
            }
        } else {
            System.out.println("Usage: java kamicup.util.EasyXPath inputfile xpath");
        }
    }
}

