/*
 * Decompiled with CFR 0.152.
 */
package kandata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kandata.client.Client;
import kandata.client.Connector;
import kandata.client.KandataClientException;
import kandata.server.ClientContext;
import kandata.server.Server;
import kandata.server.ServerContext;

public class DebugConnector
implements Connector,
ServerContext {
    static final boolean TRACE_ENABLE = true;
    static Server server = null;
    private static final String CONFIG_FILENAME = "kandata.properties";
    protected ClientContext clientContext = new ClientContext(System.currentTimeMillis());
    protected String serverClassName;
    protected String serverResourcePath;
    protected String clientEntryClassName;
    protected String clientClassPath;
    protected String clientResourcePath;

    static final void TRACE(String message) {
        System.out.println(message);
    }

    static final void TRACE(Throwable ex) {
        ex.printStackTrace(System.out);
    }

    public void connect() throws KandataClientException {
        DebugConnector.TRACE("DebugConnector.connect()");
        this.loadConfiguration(CONFIG_FILENAME);
        server.init(this);
        server.connected(this.clientContext);
    }

    public void disconnect() throws KandataClientException {
        DebugConnector.TRACE("DebugConnector.disconnect()");
        server.disconnected(this.clientContext);
        server.exit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getResource(String path) throws KandataClientException {
        byte[] byArray;
        DebugConnector.TRACE("DebugConnector.getResource(" + path + ") " + this.clientResourcePath + path);
        InputStream in = null;
        try {
            try {
                File file = new File(this.clientResourcePath + path);
                in = new FileInputStream(file);
                byte[] buf = new byte[(int)file.length()];
                in.read(buf);
                byArray = buf;
                Object var7_7 = null;
                if (in == null) return byArray;
            }
            catch (IOException e) {
                throw new KandataClientException("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f :" + this.clientResourcePath + path, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return byArray;
        }
        in.close();
        return byArray;
    }

    public String getResourcePath() {
        return this.serverResourcePath;
    }

    public Object invoke(String command, Object[] args) throws KandataClientException {
        DebugConnector.TRACE("DebugConnector.invoke(" + command + ")");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                DebugConnector.TRACE("  args[" + i + "]=" + args[i]);
            }
        }
        Object ret = command.charAt(0) == '@' ? this.invokeSystemRequest(this.clientContext, command, args) : server.invoke(this.clientContext, command, args);
        DebugConnector.TRACE("   ret=" + ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object invokeSystemRequest(ClientContext context, String command, Object[] args) {
        if (command.equals("@getEntryClassName")) {
            return this.clientEntryClassName;
        }
        if (command.equals("@getResource")) {
            byte[] byArray;
            FileInputStream in;
            block11: {
                String path = this.clientResourcePath + (String)args[0];
                DebugConnector.TRACE("path=" + path);
                in = null;
                File file = new File(path);
                byte[] buf = new byte[(int)file.length()];
                in = new FileInputStream(file);
                in.read(buf, 0, (int)file.length());
                byArray = buf;
                Object var10_11 = null;
                if (in == null) break block11;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return byArray;
            catch (IOException e) {
                Object var7_9;
                block12: {
                    try {
                        DebugConnector.TRACE(e);
                        var7_9 = null;
                        Object var10_12 = null;
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return var7_9;
            }
        }
        DebugConnector.TRACE("\u672a\u5b9a\u7fa9\u306e\u30b3\u30de\u30f3\u30c9\u3067\u3059 command=" + command);
        return null;
    }

    public String getEntryClassName() throws KandataClientException {
        return (String)this.invoke("@getEntryClassName", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadConfiguration(String fname) {
        FileInputStream in = null;
        in = new FileInputStream(fname);
        Properties prop = new Properties();
        prop.load(in);
        String appname = prop.getProperty("application.name");
        this.serverClassName = prop.getProperty("application.serverclassname");
        this.serverResourcePath = prop.getProperty("application.serverresourcepath");
        this.clientEntryClassName = prop.getProperty("application.cliententryclassname");
        this.clientClassPath = prop.getProperty("application.clientclasspath");
        this.clientResourcePath = prop.getProperty("application.clientresourcepath");
        in.close();
        DebugConnector.TRACE("application.name=" + appname);
        DebugConnector.TRACE("application.serverclassname=" + this.serverClassName);
        DebugConnector.TRACE("application.serverresourcepath=" + this.serverResourcePath);
        DebugConnector.TRACE("application.cliententryclassname=" + this.clientEntryClassName);
        DebugConnector.TRACE("application.clientclasspath=" + this.clientClassPath);
        DebugConnector.TRACE("application.clientresourcepath=" + this.clientResourcePath);
        Object var6_6 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                DebugConnector.TRACE(e);
                Object var6_7 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: java kandata.DebugConnector <server-classname>");
            System.exit(-1);
        }
        String classname = args[0];
        Class<?> serverClass = Class.forName(classname);
        server = (Server)serverClass.newInstance();
        DebugConnector connector = new DebugConnector();
        connector.connect();
        String entry_classname = connector.getEntryClassName();
        Class<?> entry_class = Class.forName(entry_classname);
        Client client = (Client)entry_class.newInstance();
        client.init(connector);
    }
}

