/*
 * Decompiled with CFR 0.152.
 */
package kandata.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellUtilExec;
import kandata.launcher.AboutAction;
import kandata.launcher.ApplicationResources;
import kandata.launcher.DeleteSiteAction;
import kandata.launcher.ExitAction;
import kandata.launcher.LaunchAction;
import kandata.launcher.Site;
import kandata.launcher.SiteCategory;
import kandata.launcher.SiteDropRegister;
import kandata.launcher.SiteInfoPane;
import kandata.launcher.SiteListBox;
import kandata.launcher.SitePropertyAction;
import kandata.launcher.Utilities;

public class KandataLauncher
extends JFrame {
    ArrayList siteCategories = this.loadEnv();
    JTabbedPane tab;
    ArrayList lists;

    KandataLauncher() {
        super("KandataLauncher");
        if (this.siteCategories == null) {
            this.siteCategories = this.createDefaultSiteCategories();
        }
        ExitAction exitAction = new ExitAction(this);
        SitePropertyAction sitePropertyAction = new SitePropertyAction(this);
        LaunchAction launchAction = new LaunchAction(this);
        DeleteSiteAction deleteSiteAction = new DeleteSiteAction(this);
        AboutAction aboutAction = new AboutAction(this);
        ActionMap actionmap = new ActionMap();
        actionmap.put("exit", exitAction);
        actionmap.put("site-property", sitePropertyAction);
        actionmap.put("launch", launchAction);
        actionmap.put("delete-site", deleteSiteAction);
        actionmap.put("about", aboutAction);
        InputMap inputmap = new InputMap();
        inputmap.put(KeyStroke.getKeyStroke(10, 1), "site-property");
        SiteDropRegister siteDropRegister = new SiteDropRegister(this);
        this.tab = new JTabbedPane();
        this.lists = new ArrayList();
        for (int i = 0; i < this.siteCategories.size(); ++i) {
            SiteCategory cat = (SiteCategory)this.siteCategories.get(i);
            SiteListBox list = new SiteListBox(this, cat);
            JScrollPane scrollPane = new JScrollPane(list);
            scrollPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.tab.addTab(cat.getName(), scrollPane);
            this.lists.add(list);
            SwingUtilities.replaceUIActionMap(list, actionmap);
            SwingUtilities.replaceUIInputMap(list, 0, inputmap);
            new DropTarget(list, 3, siteDropRegister, true);
        }
        this.tab.setSelectedIndex(this.siteCategories.size() - 1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tab, "Center");
        JToolBar toolbar = new JToolBar("Kandata");
        toolbar.setFloatable(false);
        toolbar.add(exitAction);
        toolbar.addSeparator();
        toolbar.add(launchAction);
        toolbar.add(sitePropertyAction);
        toolbar.add(deleteSiteAction);
        toolbar.addSeparator();
        toolbar.add(aboutAction);
        this.getContentPane().add((Component)toolbar, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                KandataLauncher.this.exitApplication();
            }
        });
        this.setSize(480, 480);
        this.setVisible(true);
    }

    void exitApplication() {
        this.storeEnv();
        System.exit(0);
    }

    Site getSelectedSite() {
        int curcat = this.tab.getSelectedIndex();
        if (curcat == -1) {
            return null;
        }
        SiteCategory cat = (SiteCategory)this.siteCategories.get(curcat);
        JList list = (JList)this.lists.get(curcat);
        int cursite = list.getSelectedIndex();
        if (cursite == -1) {
            return null;
        }
        Site site = cat.getSiteInfo(cursite);
        return site;
    }

    void newSite() {
        int curcat = this.tab.getSelectedIndex();
        if (curcat == -1) {
            return;
        }
        SiteCategory cat = (SiteCategory)this.siteCategories.get(curcat);
        SiteListBox list = (SiteListBox)this.lists.get(curcat);
        Site newSite = SiteInfoPane.showModal(this, "\u65b0\u3057\u3044\u30b5\u30a4\u30c8\u306e\u767b\u9332", null);
        if (newSite == null) {
            return;
        }
        cat.addSiteInfo(newSite);
        list.fireChanged();
    }

    void addSite(Site site) {
        int curcat = this.tab.getSelectedIndex();
        if (curcat == -1) {
            return;
        }
        SiteCategory cat = (SiteCategory)this.siteCategories.get(curcat);
        SiteListBox list = (SiteListBox)this.lists.get(curcat);
        cat.addSiteInfo(site);
        list.fireChanged();
    }

    void editProperty() {
        int curcat = this.tab.getSelectedIndex();
        if (curcat == -1) {
            return;
        }
        SiteCategory cat = (SiteCategory)this.siteCategories.get(curcat);
        SiteListBox list = (SiteListBox)this.lists.get(curcat);
        int cursite = list.getSelectedIndex();
        if (cursite == -1) {
            return;
        }
        Site site = cat.getSiteInfo(cursite);
        Site newSite = SiteInfoPane.showModal(this, "\u30b5\u30a4\u30c8\u306e\u7de8\u96c6", site);
        if (newSite == null) {
            return;
        }
        cat.setSiteInfo(cursite, newSite);
        list.fireChanged();
    }

    void launch() {
        int curcat = this.tab.getSelectedIndex();
        if (curcat == -1) {
            return;
        }
        SiteCategory cat = (SiteCategory)this.siteCategories.get(curcat);
        JList list = (JList)this.lists.get(curcat);
        int cursite = list.getSelectedIndex();
        if (cursite == -1) {
            return;
        }
        Site site = cat.getSiteInfo(cursite);
        String command = "java -cp kandata_launcher.jar kandata.client.http.HttpConnector " + site.getUrl();
        MdShellEnv shellenv = new MdShellEnv();
        shellenv.setIn(System.in);
        shellenv.setOut(System.out);
        shellenv.setErr(System.err);
        int rc = MdShellUtilExec.exec(shellenv, command + "&");
        System.out.println(site.getUrl() + " rc=" + rc);
    }

    int deleteSite() {
        String message;
        int curcat = this.tab.getSelectedIndex();
        if (curcat == -1) {
            return 0;
        }
        SiteCategory cat = (SiteCategory)this.siteCategories.get(curcat);
        SiteListBox list = (SiteListBox)this.lists.get(curcat);
        int[] indeces = list.getSelectedIndices();
        if (indeces == null || indeces.length == 0) {
            return 0;
        }
        if (indeces.length == 1) {
            Site site = cat.getSiteInfo(indeces[0]);
            message = site.getName() + " \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f";
        } else {
            message = "" + indeces.length + " \u500b\u306e\u30b5\u30a4\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f";
        }
        int rc = JOptionPane.showConfirmDialog(this, message, "\u30b5\u30a4\u30c8\u306e\u524a\u9664", 0);
        if (rc != 0) {
            return 0;
        }
        for (int i = indeces.length - 1; i >= 0; --i) {
            cat.removeSiteInfo(indeces[i]);
        }
        list.fireChanged();
        return indeces.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    ArrayList loadEnv() {
        block16: {
            System.out.println("loadEnv()");
            dir = System.getProperty("user.home") + File.separator + ".KandataLauncher";
            path = dir + File.separator + "KandataLauncher.properties";
            prop = new Properties();
            in = null;
            try {
                in = new FileInputStream(path);
                prop.load(in);
                var8_5 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var7_15) {
                var8_7 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var7_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (IOException e) {
                    var6_13 = null;
                    var8_6 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return var6_13;
                }
            }
        }
        System.out.println("loadEnv() \u8a2d\u5b9a\u3092\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u307f\u8fbc\u3080\u3002");
        catsize = Integer.parseInt(prop.getProperty("siteCategories.size", "0"));
        siteCategories = new ArrayList<SiteCategory>();
        for (i = 0; i < catsize; ++i) {
            catName = prop.getProperty("siteCategories." + i + ".name");
            if (catName == null) continue;
            cat = new SiteCategory(catName);
            sitesize = Integer.parseInt(prop.getProperty("siteCategories." + i + ".size", "0"));
            for (j = 0; j < sitesize; ++j) {
                url = prop.getProperty("siteCategories." + i + "." + j + ".url");
                clientType = prop.getProperty("siteCategories." + i + "." + j + ".clientType");
                version = prop.getProperty("siteCategories." + i + "." + j + ".version");
                name = prop.getProperty("siteCategories." + i + "." + j + ".name");
                desc = prop.getProperty("siteCategories." + i + "." + j + ".desc");
                iconName = prop.getProperty("siteCategories." + i + "." + j + ".iconName");
                iconExt = prop.getProperty("siteCategories." + i + "." + j + ".iconExt");
                icon = null;
                byteArray = null;
                if (iconName != null) {
                    icon = Toolkit.getDefaultToolkit().createImage(dir + File.separator + iconName);
                    try {
                        byteArray = Utilities.getByteArray(new URL(dir + File.separator + iconName));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                site = new Site(url, clientType, version, name, desc, icon);
                site.setIconEx(byteArray, iconExt);
                cat.addSiteInfo(site);
            }
            siteCategories.add(cat);
        }
        return siteCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void storeEnv() {
        System.out.println("storeEnv()");
        String dir = System.getProperty("user.home") + File.separator + ".KandataLauncher";
        new File(dir).mkdirs();
        String path = dir + File.separator + "KandataLauncher.properties";
        Properties prop = new Properties();
        prop.setProperty("siteCategories.size", "" + this.siteCategories.size());
        for (int i = 0; i < this.siteCategories.size(); ++i) {
            SiteCategory cat = (SiteCategory)this.siteCategories.get(i);
            prop.setProperty("siteCategories." + i + ".name", cat.getName());
            prop.setProperty("siteCategories." + i + ".size", "" + cat.getSize());
            for (int j = 0; j < cat.getSize(); ++j) {
                Site site = cat.getSiteInfo(j);
                prop.setProperty("siteCategories." + i + "." + j + ".url", site.getUrl());
                if (site.getClientType() != null) {
                    prop.setProperty("siteCategories." + i + "." + j + ".clientType", site.getClientType());
                }
                if (site.getVersion() != null) {
                    prop.setProperty("siteCategories." + i + "." + j + ".version", site.getVersion());
                }
                prop.setProperty("siteCategories." + i + "." + j + ".name", site.getName());
                prop.setProperty("siteCategories." + i + "." + j + ".desc", site.getDesc());
                if (site.getIconExt() == null) continue;
                String iconName = "" + i + "." + j + site.getIconExt();
                prop.setProperty("siteCategories." + i + "." + j + ".iconName", iconName);
                prop.setProperty("siteCategories." + i + "." + j + ".iconExt", site.getIconExt());
                byte[] byteArray = site.getIconByteArray();
                if (byteArray == null) continue;
                FilterOutputStream out = null;
                String iconPath = dir + File.separator + iconName;
                out = new BufferedOutputStream(new FileOutputStream(new File(iconPath)));
                ((BufferedOutputStream)out).write(byteArray, 0, byteArray.length);
                Object var13_17 = null;
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException e2) {}
                continue;
                {
                    catch (IOException e) {
                        var13_17 = null;
                        if (out == null) continue;
                        try {
                            out.close();
                        }
                        catch (IOException e2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var13_17 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
            prop.store(out, "KandataLauncher");
        }
        catch (IOException e) {
            this.showMessageBox("\u74b0\u5883\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + path, e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
    }

    ArrayList createDefaultSiteCategories() {
        byte[] byteArray;
        System.out.println("createDefaultSiteCategories()");
        ArrayList<SiteCategory> siteCategories = new ArrayList<SiteCategory>();
        siteCategories.add(new SiteCategory("\u304a\u6c17\u306b\u5165\u308a"));
        siteCategories.add(new SiteCategory("\u304a\u4ed5\u4e8b"));
        siteCategories.add(new SiteCategory("\u8da3\u5473"));
        siteCategories.add(new SiteCategory("\u305d\u306e\u4ed6"));
        SiteCategory samples = new SiteCategory("\u30b5\u30f3\u30d7\u30eb");
        Site site = new Site("http://localhost:8080/kandata-hello/servlet/kandata.server.http.ServletServer", null, null, "HelloKandata(localhost)", "\u3082\u3063\u3068\u3082\u7c21\u5358\u306a\u30b5\u30f3\u30d7\u30eb\u3067\u3059", ApplicationResources.loadImage("kandata-hello.png"));
        try {
            byteArray = Utilities.getByteArray(ApplicationResources.getUrl("kandata-hello.png"));
            site.setIconEx(byteArray, ".png");
        }
        catch (IOException e) {
            // empty catch block
        }
        samples.addSiteInfo(site);
        site = new Site("http://localhost:8080/kandata-roomreservation/servlet/kandata.server.http.ServletServer", null, null, "\u4f1a\u8b70\u5ba4\u4e88\u7d04\u30b7\u30b9\u30c6\u30e0(localhost)", "\u3061\u3087\u3063\u3068\u5f79\u306b\u7acb\u3061\u305d\u3046\u306a\u30b5\u30f3\u30d7\u30eb\u3067\u3059", ApplicationResources.loadImage("kandata-roomreservation.png"));
        try {
            byteArray = Utilities.getByteArray(ApplicationResources.getUrl("kandata-roomreservation.png"));
            site.setIconEx(byteArray, ".png");
        }
        catch (IOException e) {
            // empty catch block
        }
        samples.addSiteInfo(site);
        siteCategories.add(samples);
        return siteCategories;
    }

    void showMessageBox(String message, Throwable t) {
        StringWriter st = new StringWriter();
        t.printStackTrace(new PrintWriter(st));
        JOptionPane.showMessageDialog(this, message + "\n" + st.toString());
    }

    public static void main(String[] args) {
        new KandataLauncher();
    }
}

