/*
 * Decompiled with CFR 0.152.
 */
package kandata.client.http;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import kandata.client.Client;
import kandata.client.Connector;
import kandata.client.KandataClientException;
import kandata.client.http.HttpClassLoader;
import kandata.client.http.HttpObjectInputStream;

public class HttpConnector
implements Connector {
    private URL url = null;
    private HttpURLConnection conn = null;
    HttpClassLoader httpClassLoader = new HttpClassLoader(this);
    private String id = null;

    private HttpConnector() {
    }

    public void connect(URL url) throws KandataClientException {
        System.out.println("HttpConnector.connect(" + url + ")");
        this.url = url;
        try {
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setDoOutput(true);
        }
        catch (IOException ex) {
            throw new KandataClientException("connect failed.", ex);
        }
        this.id = (String)this.invoke("@connect", null);
    }

    public void disconnect() throws KandataClientException {
        System.out.println("HttpConnector.disconnect()");
        this.invoke("@disconnect", null);
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }

    public Object invoke(String command, Object[] args) throws KandataClientException {
        System.out.println("HttpConnector.invoke(" + command + ", args);");
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                System.out.println("\targs[" + i + "]=" + args[i]);
                ++i;
            }
        }
        try {
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setDoOutput(true);
            ObjectOutputStream out = new ObjectOutputStream(this.conn.getOutputStream());
            out.writeObject(this.id);
            out.writeObject(command);
            out.writeInt(args != null ? args.length : 0);
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    out.writeObject(args[i]);
                    ++i;
                }
            }
            out.close();
            this.conn.connect();
            HttpObjectInputStream in = new HttpObjectInputStream(this.conn.getInputStream(), this.httpClassLoader);
            Object ret = in.readObject();
            in.close();
            System.out.println("\treturn " + ret);
            this.conn.disconnect();
            return ret;
        }
        catch (IOException ex) {
            throw new KandataClientException("invoke failed.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new KandataClientException("invoke failed.", ex);
        }
    }

    public byte[] getResource(String path) throws KandataClientException {
        System.out.println("HttpConnector.getResource(" + this.url + ")");
        return (byte[])this.invoke("@getResource", new Object[]{path});
    }

    public byte[] getClass(String classname) throws KandataClientException {
        System.out.println("HttpConnector.getClass(" + this.url + ")");
        return (byte[])this.invoke("@getClass", new Object[]{classname});
    }

    public String getEntryClassName() throws KandataClientException {
        return (String)this.invoke("@getEntryClassName", null);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: java kandata.client.http.HttpConnector <url>");
            System.exit(-1);
        }
        HttpConnector connector = new HttpConnector();
        connector.connect(new URL(args[0]));
        String entry_classname = connector.getEntryClassName();
        Class<?> entry_class = Class.forName(entry_classname, true, connector.httpClassLoader);
        Client client = (Client)entry_class.newInstance();
        client.init(connector);
    }
}

