/*
 * Decompiled with CFR 0.152.
 */
package kandata.launcher;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import kandata.launcher.KandataLauncher;
import kandata.launcher.SiteInfo;

class SiteDropRegister
implements DropTargetListener {
    private KandataLauncher launcher;

    SiteDropRegister(KandataLauncher launcher) {
        this.launcher = launcher;
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrag(3);
        }
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        if (!e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            e.acceptDrop(3);
            Transferable t = e.getTransferable();
            String str = (String)t.getTransferData(DataFlavor.stringFlavor);
            System.out.println("drop \u6587\u5b57\u5217:" + str);
            e.dropComplete(true);
            URL url = new URL(str);
            InputStream in = url.openStream();
            Properties prop = new Properties();
            prop.load(in);
            in.close();
            SiteInfo site = this.createSiteFromProperties(prop);
            if (site == null) {
                return;
            }
            this.launcher.addSite(site);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.dropComplete(false);
            this.launcher.showMessageBox("\u30b5\u30a4\u30c8\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
    }

    SiteInfo createSiteFromProperties(Properties prop) throws MalformedURLException {
        String name = prop.getProperty("Name");
        String desc = prop.getProperty("Desc");
        String url = prop.getProperty("Url");
        String clientType = prop.getProperty("ClientType");
        String version = prop.getProperty("Version");
        String iconUrl = prop.getProperty("IconUrl");
        System.out.println("Name=" + name);
        System.out.println("Desc=" + desc);
        System.out.println("Url=" + url);
        System.out.println("ClientType=" + clientType);
        System.out.println("Version=" + version);
        System.out.println("IconUrl=" + iconUrl);
        if (name == null || url == null) {
            return null;
        }
        Image icon = null;
        if (iconUrl != null) {
            icon = Toolkit.getDefaultToolkit().createImage(new URL(iconUrl));
        }
        if (icon == null) {
            icon = SiteInfo.getUnregistedImage();
        }
        System.out.println("Icon=" + icon + " width=" + icon.getWidth(this.launcher) + " height=" + icon.getHeight(this.launcher));
        try {
            BufferedImage bi = new BufferedImage(100, 100, 6);
            bi.getGraphics().drawImage(icon, 0, 0, this.launcher);
            ImageIO.write((RenderedImage)bi, "png", new File("foo.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new SiteInfo(url, clientType, version, name, desc, icon);
    }
}

