
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.io.*;
import java.util.*;

public class MdShellCommandCodeConv
	extends MdShellCmdDefault
{
	public MdShellCommandCodeConv()
	{
		setCommand("codeconv");
		setDisplayString("code convert (like \"EUC_JP\" to \"SJIS\") [experimental]");
	}

	public void processCommand(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		Vector vecList=new Vector();
		vecList.addElement("EUC_JP");
		vecList.addElement("ISO2022JP");
		vecList.addElement("SJIS");
		vecList.addElement("UNICODE");

		MdShellDirFileAbstract dirfileInput=MdShellSelectFileUtil.selectFile(shellenv);

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select input code: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strInputEncoding=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));
		if(strInputEncoding==null)
		{
			throw new MdShellCancelException();
		}

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select output code: ");
		String strOutputEncoding=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));
		if(strOutputEncoding==null)
		{
			throw new MdShellCancelException();
		}

		try{
			MdShellDirFileAbstract dirfileOutput=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,dirfileInput.getName()+"."+strOutputEncoding,false);
			BufferedReader reader=new BufferedReader(new InputStreamReader(dirfileInput.getInputStream(),strInputEncoding));
			BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(dirfileOutput.getOutputStream(),strOutputEncoding));

			shellenv.getOut().println("converting "+dirfileInput.getName()+" to "+dirfileOutput.getName());

			for(;;)
			{
				String strRead=reader.readLine();
				if(strRead==null)break;
				writer.write(strRead);
				writer.newLine();
			}
			writer.flush();
			writer.close();
			reader.close();
			dirfileOutput.setLastModified(dirfileInput.getLastModified());
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}

	}
}


