
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.io.*;
import java.text.Collator;
import java.util.StringTokenizer;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MdShellCommandEdit
	extends MdShellCmdDefault
{
	public MdShellCommandEdit()
	{
		setCommand("edit");
		setDisplayString("text editor");
	}

	public void processCommand(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		{
			String strFilename=getFileNameFromHistory(shellenv);
			if(strFilename==null)
			{
				// It is changed so that may not do when there is no designation. 
				// 'hidemaru editor' doesn't become known as soon as there are somewhat 
				// a problem or relations in unusual input of a movement standard 
				// and so on without file name designation though EDITOR is about to want 
				// to start without file name designation.
			}
			else
			{
				StringTokenizer toknizerTab=new StringTokenizer(strFilename,"\t\n",false);
				for(;;)
				{
					String strFile=null;
					try{
						strFile=toknizerTab.nextToken();
					}catch(NoSuchElementException ex){
						// finished.
						break;
					}
					MdShellUtilExec.exec(shellenv,shellenv.getCommandList().getFullPathNameByCommand("$edit")+" "+MdShellDirFactory.quoteFileNameWhenSpaceIsExist(strFile)+"&");
				}
			}
		}
	}

	/**
	 * select file from file history.
	 */
	private String getFileNameFromHistory(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		String strFilename=null;
		MdShellListSelection.showVectorListWithNumberAndString(shellenv,shellenv.getFileHistory(),new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select file.: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		strFilename=formatter.format(MdShellListSelection.selectFromList(shellenv,shellenv.getFileHistory(),formatter,shellenv.getNextLine()));
		if(strFilename==null)
		{
			throw new MdShellCancelException();
		}
		shellenv.getOut().println("get from history ["+strFilename+"]");
		return strFilename;
	}
}


