
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import java.io.*;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public class MdShellDirFactory
{
	public static final char URI_SEPARATOR_CHAR='/';
	public static final String URI_SEPARATOR_STRING="/";

	public static final MdShellDirNodeInterface getInstance(MdShellEnv shellenv,String strUri,boolean isDirectory)
	{
		if(MdShellDef.IS_DEBUG)System.out.println("MdShellDirFactory.getInstance("+strUri+","+isDirectory+")");
		switch(getDeviceType(strUri))
		{
			case MdShellDirNodeInfo.ROOT:
				return new MdShellDirDirectoryRoot();
			case MdShellDirNodeInfo.FILE:
				String strWithoutId=MdShellDirFactory.uri2native(strUri);
				if(isDirectory)
				{
					return new MdShellDirDirectoryFileSystem(shellenv,strUri,new File(strWithoutId));
				}
				else
				{
					return new MdShellDirFileFileSystem(shellenv,new File(strWithoutId));
				}
			case MdShellDirNodeInfo.FTP:
				if(isDirectory)
				{
					return new MdShellDirDirectoryFtpClient(shellenv,strUri);
				}
				else
				{
					return new MdShellDirFileFtpClient(shellenv,strUri);
				}
			default:
				System.out.println("not implemented. at MdShellDirFactory.getInstance("+strUri+")");
				return null;
		}
	}

	public static final String trimDeviceName(String strUri)
	{
		int iType=getDeviceType(strUri);
		if(iType>=0)
		{
			return strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[iType].length());
		}
		else
		{
			return strUri;
		}
	}

	/**
	 * convert URI to native fs pathname.
	 */
	public static final String uri2native(String strUri)
	{
		int iType=getDeviceType(strUri);
		if(iType>=0)
		{
			strUri=strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[iType].length());
		}

		// Windows Device special.
		if(strUri.indexOf(':')>=0)
		{
			if(strUri.startsWith(URI_SEPARATOR_STRING))
			{
				strUri=strUri.substring(1);
			}
		}

		return strUri.replace(URI_SEPARATOR_CHAR,getNativeFsSeparatorChar());
	}

	/**
	 * convert native fs pathname to URI.
	 */
	public static final String native2uri(String strLocalPathName)
	{
		int iType=getDeviceType(strLocalPathName);
		if(iType>=0)
		{
			if(MdShellDef.IS_DEBUG)System.out.println("MdShellDirFactory.native2uri("+strLocalPathName+") is illegal arg");
			strLocalPathName=strLocalPathName.substring(MdShellDirNodeInfo.SZ_PROTOCOL[iType].length());
		}

		strLocalPathName=strLocalPathName.replace(getNativeFsSeparatorChar(),URI_SEPARATOR_CHAR);
		if(strLocalPathName.startsWith(URI_SEPARATOR_STRING)==false)
		{
			strLocalPathName=URI_SEPARATOR_STRING+strLocalPathName;
		}
		return MdShellDirNodeInfo.SZ_PROTOCOL[MdShellDirNodeInfo.FILE]+strLocalPathName;
	}

	public static final char getNativeFsSeparatorChar()
	{
		String strSeparator=getNativeFsSeparator();
		return strSeparator.charAt(0);
	}

	public static final String getNativeFsSeparator()
	{
		return System.getProperty("file.separator");
	}

	public static final int getDeviceType(String strUri)
	{
		for(int index=0;index<MdShellDirNodeInfo.SZ_PROTOCOL.length;index++)
		{
			if(strUri.startsWith(MdShellDirNodeInfo.SZ_PROTOCOL[index]))
			{
				return index;
			}
		}
		return -1;
	}

	public static final String getDirectory(String strUri,boolean isUriDirectoryName)
	{
		String strDirectory=strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[MdShellDirNodeInfo.FTP].length());

		if(strDirectory.length()==0)
		{
			return "/";
		}

		if(strDirectory.charAt(0)!='/')
		{
			// it contain host name
			// trim host name
			int iFind=strDirectory.indexOf('/');
			if(iFind<0)
			{
				strDirectory="/";
			}
			else
			{
				strDirectory=strDirectory.substring(iFind);
			}
		}

		if(isUriDirectoryName==false)
		{
			// trim file name
			int iFind=strDirectory.lastIndexOf('/');
			if(iFind<0)
			{
				;
			}
			else
			{
				strDirectory=strDirectory.substring(0,iFind);
			}
		}

		if(strDirectory.length()==0)
		{
			strDirectory="/";
		}

		return strDirectory;
	}

	public static final String getHostName(String strUri)
	{
		String strWithoutId=strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[MdShellDirNodeInfo.FTP].length());

		String strHostName="";

		int iFind=strWithoutId.indexOf('/');
		if(iFind<0)
		{
			strHostName=strWithoutId;
		}
		else
		{
			strHostName=strWithoutId.substring(0,iFind);
		}
		return strHostName;
	}

	public static final String quoteFileNameWhenSpaceIsExist(String strArg)
	{
		if(strArg.indexOf(' ')<0)
		{
			return strArg;
		}
		return "\""+strArg+"\"";
	}

	public static final String getWindowsRootStyle()
	{
		return ":"+URI_SEPARATOR_STRING;
	}

	public static final String getShortName(String strFullName)
	{
		strFullName=MdShellDirFactory.trimDeviceName(strFullName);

		if(strFullName.length()==1)
		{
			// only 1 char, then it's LINUX's root.
			return strFullName;
		}

		int iFindCut=strFullName.lastIndexOf(URI_SEPARATOR_CHAR);
		if(iFindCut<0)
		{
			return null;
		}

		boolean isEndWithWindowsRootStyle=strFullName.endsWith(getWindowsRootStyle());
		if(isEndWithWindowsRootStyle)
		{
			// root of this drive
			return strFullName;
		}
		else
		{
			return strFullName.substring(iFindCut+1);
		}
	}
	
	public static final String getPathWithoutShortName(String strFullName)
	{
		if(MdShellDef.IS_DEBUG)System.out.println("MdShellDirFactory.getPathWithoutShortName("+strFullName+")");
		// separator bugbugbug
		int iFindCut=strFullName.lastIndexOf(URI_SEPARATOR_CHAR);
		if(iFindCut<0)
		{
			return null;
		}
		int iFindFirst=strFullName.indexOf(URI_SEPARATOR_CHAR);
		boolean isEndWith=strFullName.endsWith(URI_SEPARATOR_STRING);
		if(iFindCut==iFindFirst
		&& isEndWith)
		{
			if(MdShellDef.IS_DEBUG)System.out.println("MdShellDirFactory.getPathWithoutShortName("+strFullName+") results "+strFullName);
			return strFullName;
		}
		else
		{
			if(MdShellDef.IS_DEBUG)System.out.println("MdShellDirFactory.getPathWithoutShortName("+strFullName+") results "+strFullName.substring(0,iFindCut));
			strFullName=strFullName.substring(0,iFindCut);
			if(strFullName.length()==0)
			{
				// for root.
				strFullName=URI_SEPARATOR_STRING;
			}
			return strFullName;
		}
	}
}


