package kandata.launcher;

import java.io.*;
import java.net.URL;
import java.util.Properties;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.dnd.*;
import java.awt.datatransfer.*;

/** hbvAIɃTCgo^NX */
class SiteDropRegister implements DropTargetListener {

	private KandataLauncher launcher;
	SiteDropRegister(KandataLauncher launcher) {
		this.launcher = launcher;
	}
	// hbOꂽ̂ĂB
	public void dragEnter(DropTargetDragEvent e) {
		// Ȃ󂯕t
		if ( e.isDataFlavorSupported(DataFlavor.stringFlavor) ) {
			e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);	// 󂯓
		}
	}
	public void dragExit(DropTargetEvent e) {}
	public void dragOver(DropTargetDragEvent e) {}
	public void dropActionChanged(DropTargetDragEvent e) {}
	// hbvꂽBTransferablef[^擾B
	public void drop(DropTargetDropEvent e) {
		// ȊOȂ󂯕tȂB
		if ( ! e.isDataFlavorSupported(DataFlavor.stringFlavor) ) return;
		try {
			e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			Transferable t = e.getTransferable();
			String str = (String)t.getTransferData(DataFlavor.stringFlavor);
			System.out.println("drop :"+str);
			e.dropComplete(true);
			// URLvpeBt@C擾
			URL url = new URL(str);
			InputStream in = url.openStream();
			Properties prop = new Properties();
			prop.load(in);
			in.close();
			// vpeBTCg쐬
			Site site = createSiteFromProperties(prop);
			if (site == null) return;
			// IĂJeS̖ɃTCgo^
			launcher.addSite(site);
		}
		catch(Exception ex) {
			ex.printStackTrace();
			e.dropComplete(false);
			launcher.showMessageBox("TCg̎擾Ɏs܂", ex);
		}
    }
    /** vpeBTCg쐬. */
    Site createSiteFromProperties(Properties prop)
    					throws Exception {
		// Kvȏ擾
		String name = prop.getProperty("Name");
		String desc = prop.getProperty("Desc");
		String url  = prop.getProperty("Url");
		String clientType = prop.getProperty("ClientType");
		String version = prop.getProperty("Version");
		String iconUrl = prop.getProperty("IconUrl");
		System.out.println("Name="+name);
		System.out.println("Desc="+desc);
		System.out.println("Url="+url);
		System.out.println("ClientType="+clientType);
		System.out.println("Version="+version);
		System.out.println("IconUrl="+iconUrl);
		if (name==null || url==null ) return null;
		// ACR̉摜URL擾B
		Image icon = null;
		if (iconUrl != null) {
			icon = Toolkit.getDefaultToolkit().createImage(new URL(iconUrl));
		}
		// ACRȂƂɂ́Ao^p̃ACRɂB
		if (icon == null) {
			icon = Site.getUnregistedImage();
		}
		System.out.println("Icon="+icon);
		Site site = new Site(url, clientType, version, name, desc, icon);
		// ACR̃oCgzƊgq擾B
		byte[] byteArray = Utilities.getByteArray(new URL(iconUrl));
		String ext = iconUrl.substring(iconUrl.lastIndexOf('.'));
		System.out.println("ext="+ext);
		site.setIconEx(byteArray, ext);
		return site;
	}
}

/*
		// hbv\ɂ
        new DropTarget(launcher, DnDConstants.ACTION_COPY_OR_MOVE, new DropRegister(launcher), true);
*/