package kandata.launcher;

import java.io.*;
import java.util.*;
import java.awt.Image;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.GridLayout;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;

/**
 * TCg̃vpeB.
 * JPanelƂč쐬AJOptionPanegĕ\B
 */
class SiteInfoPane extends JPanel implements ChangeListener {
	JTextField nameField;
	JTextField descField;
	JTextField urlField;
	JTextField clientTypeField;
	JTextField versionField;
	JCheckBox clientTypeCheck;
	JCheckBox versionCheck;
	JButton ok;
	JButton cancel;
	Image image;
	Site site;

	SiteInfoPane() {
		nameField       = new JTextField();
		descField       = new JTextField();
		urlField        = new JTextField();
		clientTypeField = new JTextField();
		versionField    = new JTextField();
		clientTypeCheck = new JCheckBox("NCAg^Cv");
		clientTypeCheck.addChangeListener(this);
		versionCheck    = new JCheckBox("o[W");
		versionCheck.addChangeListener(this);
		setLayout(new GridLayout(11, 1, 5,5));
		add(new JLabel("O"));
		add(nameField);
		add(new JLabel("ڍׂȐ"));
		add(descField);
		add(new JLabel("URL"));
		add(urlField);
		add(clientTypeCheck);
		add(clientTypeField);
		add(versionCheck);
		add(versionField);
//		add(new JLabel("ZLeBǗ"));
//		add(new JLabel("ӏ쒆 (^^;"));
		add(new JButton(new RegistFromClipboard(this)));	// e؂ȍ\z
//		setBorder(new EmptyBorder(10,10,10,10));
	}
	void setSite(Site site) {
		this.site = site;
		nameField.setText(site.getName());
		descField.setText(site.getDesc());
		urlField.setText(site.getUrl());
		if (site.getClientType() != null) {
			clientTypeCheck.setSelected(true);
			clientTypeField.setText(site.getClientType());
			clientTypeField.setEditable(true);
		}
		else {
			clientTypeCheck.setSelected(false);
			clientTypeField.setText("");
			clientTypeField.setEditable(false);
		}
		if (site.getVersion() != null) {
			versionCheck.setSelected(true);
			versionField.setText(site.getVersion());
			versionField.setEditable(true);
		}
		else {
			versionCheck.setSelected(false);
			versionField.setText("");
			versionField.setEditable(false);
		}
		image = site.getIcon();
	}
	Site getSite() {
		return new Site(
			urlField.getText(),
			(clientTypeCheck.isSelected() ? clientTypeField.getText() : null),
			(versionCheck.isSelected() ? versionField.getText() : null),
			nameField.getText(),
			descField.getText(),
			image);
	}

	/** Xi[̑Ώۂ̏ԂύXꂽƂɌĂяo܂BChangeListener interface */
	public void stateChanged(ChangeEvent e) {
		if ( e.getSource() == clientTypeCheck ) {
			clientTypeField.setEditable(clientTypeCheck.isSelected());
		}
		else if ( e.getSource() == versionCheck ) {
			versionField.setEditable(versionCheck.isSelected());
		}
	}
	/** JOptionPanegă_CAO\. */
	static Site showModal(Component parent, String title, Site site) {
		SiteInfoPane pane = new SiteInfoPane();
		if (site != null) {
			pane.setSite(site);
		}
		int rc = JOptionPane.showConfirmDialog(parent, pane, title,
						JOptionPane.OK_CANCEL_OPTION,
						JOptionPane.PLAIN_MESSAGE, null);
		if (rc == JOptionPane.CANCEL_OPTION) return null;
		return pane.getSite();
	}

	/** Nbv{[hꔭo^ */
	class RegistFromClipboard extends AbstractAction {
		SiteInfoPane pane;
		public RegistFromClipboard(SiteInfoPane pane) {
			super("Nbv{[hꔭo^");
			this.pane = pane;
			
		}
		/** ANVƌĂяo܂B */
		public void actionPerformed(ActionEvent e) {
			// Nbv{[h當擾
			Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
			Transferable t = c.getContents(this); // قƂǂ̏ꍇAthisł悢B
			try {
				String s = (String) t.getTransferData(DataFlavor.stringFlavor);
				System.out.println("y[Xgꂽ:"+s);
				// vpeBɓ
				Properties prop = new Properties();
				BufferedReader reader = null;
				try {
					reader = new BufferedReader(new StringReader(s));
					while (reader.ready()) {
						String line = reader.readLine();
						if (line == null) break;
						int pos = line.indexOf('=');
						String key   = line.substring(0, pos);
						String value = line.substring(pos+1);
						System.out.println("key=["+key+"] value=["+value+"]");
						prop.put(key, value);
					}
				}
				finally {
					if (reader == null) reader.close();
				}
				// Kvȏ擾
				String name = prop.getProperty("Name");
				String desc = prop.getProperty("Desc");
				String url  = prop.getProperty("Url");
				String clientType = prop.getProperty("ClientType");
				String version = prop.getProperty("Version");
				String iconUrl = prop.getProperty("IconUrl");
				System.out.println(name);
				System.out.println(desc);
				System.out.println(url);
				System.out.println(clientType);
				System.out.println(version);
				System.out.println(iconUrl);
				if (name==null || url==null ) {
					JOptionPane.showMessageDialog(pane, "Nbv{[h̓ǂݍ݂Ɏs܂", 
							"Nbv{[hꔭo^", JOptionPane.ERROR_MESSAGE);
					return;
				}
				// 擾eR|[lgɐݒ肷
				setSite(new Site(url, clientType, version, name, desc, null));	// TODO: iconUrlIcon擾
			}
			catch (Exception ex) {
				ex.printStackTrace();
				//Toolkit.getDefaultToolkit().beep();
				JOptionPane.showMessageDialog(pane, "Nbv{[h̓ǂݍ݂Ɏs܂", "Nbv{[hꔭo^", JOptionPane.ERROR_MESSAGE);
			}
		}
	}



}

/*
	Nbv{[h̃̕Tv
Name=c\VXe(localhost)
Desc=ƖɗȃTvł
Url=http://localhost:8080/kandata-roomreservation/servlet/kandata.server.http.ServletServer
Icon=
*/
