/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package kandata.server.http;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import kandata.server.*;


/**
 * KandataT[oServletł.
 */
public class ServletServer extends HttpServlet implements ServerContext {

	static final boolean TRACE_ENABLE = true;
	static final void TRACE(String message) { if (TRACE_ENABLE) System.out.println(message); }
	static final void TRACE(Throwable ex) { if (TRACE_ENABLE) ex.printStackTrace(System.out); }

	/** ݒt@C. */
	private static final String CONFIG_FILENAME = "kandata.properties";

	/** AvP[VT[o. */
	protected Server server;

	/** T[oAṽNX. */
	protected String serverClassName;

	/** T[o\[X̃pX. */
	protected String serverResourcePath;

	/** NCAgAṽGgNX. */
	protected String clientEntryClassName;

	/** NCAgAṽNXpX. */
	protected String clientClassPath;	// separatorȂB

	/** NCAg\[X̃pX. */
	protected String clientResourcePath;

	/** NCAgEReLXgi[. ZbVIDƊ֘At邱Ƃɂ. */
	private HashMap clientContextMap = new HashMap();	// <String, ClientContext>

	/** T[ubg̏. */
	public void init() throws ServletException {
		TRACE("<<< init() >>>");
		super.init();

		// ݒt@Cǂݍ
		loadConfiguration(CONFIG_FILENAME);

		// AvP[VT[o𐶐
		try {
			server = (Server) Class.forName(serverClassName).newInstance();
		} catch (Exception e) {
			TRACE(e);
		}
		// AvP[VT[ȍ
		server.init(this);
	}

	/**
	 * GETv܂.
	 */
	public void doGet(	HttpServletRequest request, HttpServletResponse response)
											throws IOException, ServletException {
		//TRACE("<<< doGet() >>> session.Id="+request.getSession().getId());
	}

	/**
	 * POSTv܂.
	 */
	public void doPost(	HttpServletRequest request,
						HttpServletResponse response)
						throws IOException, ServletException {
		//TRACE("<<< doPost() >>> session.Id="+request.getSession().getId());

		try {
			// ݓ
			long now = System.currentTimeMillis();

			// NCAgIDA\bhƈ擾B
			ObjectInputStream in = new ObjectInputStream(request.getInputStream());
			String id = (String) in.readObject();
			String command = (String) in.readObject();
			int args_len = in.readInt();
			TRACE("  ID="+id+" command=["+command+"] args_len="+args_len+" -------------------");
			Object[] args = new Object[args_len];
			for (int i=0; i<args_len; i++) {
				args[i] = in.readObject();
				TRACE("  args["+i+"]="+args[i]);
			}
			in.close();

			// NCAgReLXgTB
			ClientContext context = (ClientContext) clientContextMap.get(id);

			// ĂԁI
			Object ret;
			if (command.charAt(0) == '@') {
				if (command.equals("@connect")) {
					// VNCAgReLXg𐶐.
					context = new ClientContext(now);
					clientContextMap.put(context.getId(), context);
				}
				ret = invokeSystemCommand(context, command, args);
				if (command.equals("@disconnect")) {
					// NCAgReLXg폜.
					clientContextMap.remove(id);
				}
			}
			else {
				ret = server.invoke(context, command, args);
			}
			TRACE("  ret="+ret);
			// ߂lݒ肷B
			ObjectOutputStream out = new ObjectOutputStream(response.getOutputStream());
			out.writeObject(ret);
			out.close();
			// ŏIANZXL
			context.setLastAccessTimeMillis(now);
		}
		catch (Exception e) {
			TRACE(e);
		}
	}

	/**
	 * VXeR}h.
	 */
	protected Object invokeSystemCommand(ClientContext context, String command, Object[] args) {

		if (command.equals("@getClass")) {
			String classname = (String) args[0];
			String path = getWebInfPath() + File.separator + clientClassPath + File.separator + classname.replace('.', File.separatorChar) + ".class";
			TRACE("path="+path);
			FileInputStream in = null;
			try {
				File file = new File(path);
				byte[] buf = new byte[(int) file.length()];
				in = new FileInputStream(file);
				in.read(buf, 0, (int) file.length());
				return buf;
			} catch (IOException e) {
				TRACE(e);
				return null;
			}
			finally {
				if (in != null) try { in.close(); } catch (IOException e) {}
			}
		}
		else if (command.equals("@getResource")) {
			String path = getWebInfPath() + File.separator + clientResourcePath + (String) args[0];
			TRACE("path="+path);
			FileInputStream in = null;
			try {
				File file = new File(path);
				byte[] buf = new byte[(int) file.length()];
				in = new FileInputStream(file);
				in.read(buf, 0, (int) file.length());
				return buf;
			} catch (IOException e) {
				TRACE(e);
				return null;
			}
			finally {
				if (in != null) try { in.close(); } catch (IOException e) {}
			}
		}
		else if (command.equals("@connect")) {
			server.connected(context);
			return context.getId();
		}
		else if (command.equals("@disconnect")) {
			server.disconnected(context);
		}
		else if (command.equals("@getEntryClassName")) {
			return clientEntryClassName;
		}
		else {
			TRACE("unknown command="+command);
		}
		return null;
	}

	/**
	 * ݒǂݍ.
	 * XMLł͂ȂAPropertiesɂĂBJDK1.3ł̓ftHgœĂȂ̂.
	 */
	protected void loadConfiguration(String fname) {
		FileInputStream in = null;
		try {
			in = new FileInputStream(getWebInfPath() + File.separator + fname);
			Properties prop = new Properties();
			prop.load(in);
			String appname       = prop.getProperty("application.name");
			serverClassName      = prop.getProperty("application.serverclassname");
			serverResourcePath   = prop.getProperty("application.serverresourcepath");
			clientEntryClassName = prop.getProperty("application.cliententryclassname");
			clientClassPath      = prop.getProperty("application.clientclasspath");
			clientResourcePath   = prop.getProperty("application.clientresourcepath");
			in.close();
			TRACE("application.name="+appname);
			TRACE("application.serverclassname="+serverClassName);
			TRACE("application.serverresourcepath="+serverResourcePath);
			TRACE("application.cliententryclassname="+clientEntryClassName);
			TRACE("application.clientclasspath="+clientClassPath);
			TRACE("application.clientresourcepath="+clientResourcePath);
		}
		catch (IOException e) {
			TRACE(e);
		}
		finally {
			if (in != null) try { in.close(); } catch (IOException e) {}
		}
	}

	/** T[oI܂. */
	public void destroy() {
		server.exit();
	}

	public String getResourcePath() {
		return getWebInfPath() + File.separator + serverResourcePath;
	}
	/** %TOMCAT_HOME%/webapps/WEB-INF ̃fBNgԂ. */
	private String getWebInfPath() {
		return getServletContext().getRealPath("/WEB-INF");
	}
}

