/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package roomreservation.common;

import java.io.Serializable;

/** ̗\ */
public class Reservation implements Serializable {
	private String name;		// \񂵂l ex."n `"
	private String roomName;	// ̖O ex."Pc"
	private String date;		// \񂵂t ex."2003/05/25"
	private String startTime;	// \Jn   ex."13:00"
	private String endTime;		// \I   ex."15:00"
	private String memo;		//          ex."Prj~[eBO"

	// getter / setter
	public String getName() { return name; }
	public void setName(String name) { this.name = name; }
	public String getRoomName() { return roomName; }
	public void setRoomName(String roomName) { this.roomName = roomName; }
	public String getDate() { return date; }
	public void setDate(String date) { this.date = date; }
	public String getStartTime() { return startTime; }
	public void setStartTime(String start) { this.startTime = start; }
	public String getEndTime() { return endTime; }
	public void setEndTime(String end) { this.endTime = end; }
	public String getMemo() { return memo; }
	public void setMemo(String memo) { this.memo = memo; }
	public String toString() {
		return "Reservation[name="+name+",roomName="+roomName+
				",date="+date+",startTime="+startTime+",endTime="+endTime+",memo="+memo+"]";
	}
	public boolean equals(Object o) {
		Reservation r = (Reservation) o;
		if (r==null) return false;
		if (! roomName.equals(r.getRoomName())) return false;
		if (! date.equals(r.getDate())) return false;
		if (! startTime.equals(r.getStartTime())) return false;
		return true;
	}
}

