/*
 *  gnu/regexp/util/Egrep.java
 *  Copyright (C) 1998 Wes Biggs
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package gnu.regexp.util;
import gnu.regexp.RESyntax;

/**
 * This is a front end to the gnu.regexp.util.Grep class which sets the
 * syntax used to RE_SYNTAX_EGREP, which aims to emulate the standard UNIX
 * egrep command.
 *
 * @author <A HREF="mailto:wes@cacas.org">Wes Biggs</A>
 * @version 1.01
 * @use gnu.getopt
 */
public class Egrep {
  private Egrep() { }

  /**
   * Invokes Grep.grep() using the RE_SYNTAX_EGREP syntax and the
   * command line arguments specified.  Output is sent to System.out.
   * For a list of options, use the argument "--help".
   */
  public static void main(String[] argv) {
    //System.exit(Grep.grep(argv,RESyntax.RE_SYNTAX_EGREP,System.out));
    Grep.grep(argv,RESyntax.RE_SYNTAX_EGREP,System.out);
  }
}

