
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.util.dir;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.util.Vector;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.io.*;
import java.util.*;
import java.text.SimpleDateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Dir
{
	/**
	 * list files in this directory.
	 */
	public int process(MdShellEnv shellenv,String[] strArgs)
	{
		Vector vecList=buildData(shellenv,strArgs);
		if(vecList==null)
		{
			return -2;
		}
		showData(shellenv,vecList);

		return 0;
	}

	private boolean isRecursive=false;
	private boolean isSortByTimeStamp=false;
	private boolean isSortByFileSize=false;

	public Vector buildData(MdShellEnv shellenv,String[] strArgs)
	{

		LongOpt[] longOptions = { 
			new LongOpt("help",		LongOpt.NO_ARGUMENT, null, '?'),
			new LongOpt("recursive",	LongOpt.NO_ARGUMENT, null, 'R'),
			new LongOpt("version",		LongOpt.NO_ARGUMENT, null, 'V')
		};

		Getopt g = new Getopt("dir", strArgs, "ailrRStV?", longOptions);
		int c;
		while((c=g.getopt()) != -1)
		{
			switch (c) {
				case 'R':
					isRecursive=true;
					break;
				case 'S':
					isSortByFileSize=true;
					break;
				case 't':
					isSortByTimeStamp=true;
					break;
				case 'V':
					break;
				case '?': // help
					BufferedReader reader=new BufferedReader(new InputStreamReader((Dir.class).getResourceAsStream("DirUsage.txt")));
					try {
						String strLine=null;
						while((strLine=reader.readLine())!=null)
						{
							shellenv.getOut().println(strLine);
						}
						reader.close();
					}catch(IOException ex){
						System.out.println(ex.toString());
						ex.printStackTrace();
					}
					return null;
			}
		}

		String strFileRegExp="";
		{
			int optind=g.getOptind();
			if (optind<strArgs.length)
			{
				strFileRegExp=MdShellUtilString.eraseChar(strArgs[g.getOptind()],'*');
			}
		}

		Vector vecList=null;
		if(isRecursive)
		{
			vecList=shellenv.getCurrentDirectory().listDirectoryWithSubDirectory(shellenv,MdShellDirNodeInfo.SELECT_DIRECTORY_FILE,strFileRegExp);
		}
		else
		{
			vecList=shellenv.getCurrentDirectory().listDirectory(shellenv,MdShellDirNodeInfo.SELECT_DIRECTORY_FILE,strFileRegExp);
		}

		if(isSortByTimeStamp)
		{
			Collections.sort(vecList,new MdShellFileTimestampComparator());
		}
		if(isSortByFileSize)
		{
			Collections.sort(vecList,new MdShellFileSizeComparator());
		}

		return vecList;
	}

	public void showData(MdShellEnv shellenv,Vector vecList)
	{

		int iBaseLength=shellenv.getCurrentDirectory().getName().length();

		MdShellDirLongListFormatter formatter=new MdShellDirLongListFormatter();

		for(int index=0;index<vecList.size();index++)
		{
			MdShellDirNodeInterface path=(MdShellDirNodeInterface)vecList.elementAt(index);
			// it is'nt go well. : strbufWrk.append(fileCheckFile.getPath());
			shellenv.getOut().println(formatter.format(path));
		}

		NumberFormat numberfmt=NumberFormat.getNumberInstance();
		shellenv.getOut().println("     total: "+numberfmt.format(formatter.iTotalDirectoryCount)+" directories: "+numberfmt.format(formatter.iTotalFileCount)+" files: total "+numberfmt.format(formatter.iTotalFileLength)+" bytes");
	}






	//public static boolean isDirectoryExist(String strFullPathDirectory)
	//{
	//	File fileCheck=new File(strFullPathDirectory);
	//	//shellenv.getOut().println("checking: "+strFullPathDirectory+" is exist?");
	//	return fileCheck.exists();
	//}
}


