%define debug_package %{nil}
%define debug 1

%if %{?rhel5:0}%{!?rhel5:1}
%define rhel5 1
%endif

%define _target         libvirt
%define _vendor_name    hde
%define _name           %{_vendor_name}-%{_target}

%define _prefix         /opt/%{_vendor_name}
%define _datadir        %{_prefix}/share
%define _mandir         %{_prefix}/share/man
%define _defaultdocdir  %{_prefix}/share/doc
%define _logdir         /var/log/%{_name}
%define _localstatedir  /var
%define _sysconfdir     /etc%{_prefix}
%define _libvirt_datadir /var%{_prefix}/%{_target}

%define python_sitelib  %{_prefix}/lib/python

%define _group          kss

%define with_xen       1
%define with_xen_proxy 1
%define with_qemu      0
%define with_polkit    0

# Xen is available only on i386 x86_64 ia64
%ifnarch i386 i686 x86_64 ia64
%define with_xen 0
%endif

%if ! %{with_xen}
%define with_xen_proxy 0
%endif

%if "%{fedora}"
%ifarch ppc64
%define with_qemu 0
%endif
%endif

Summary: Library providing a simple API virtualization
Name: %{_name}
Version: 0.7.0
Release: 1
License: LGPL
Group: Development/Libraries
Source: http://libvirt.org/sources/libvirt-%{version}.tar.gz
Source100: libvirtd.sysconf
Source101: libvirtd.conf
Source102: libvirtd.init
Source200: genkey.sh
Patch100: libvirt-0.4.5-graphic-xpath.patch
Patch101: libvirt-0.5.0-dbus-1.patch
Patch110: libvirt-0.7.0-no_ipv6_support.patch
Patch200: libvirt-0.4.6-vendor_xm_config_dir.patch
Patch201: libvirt-0.7.0-hde_dir.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
URL: http://libvirt.org/
Vendor: HDE,Inc.
Packager: Taizo ITO <taizo.ito@hde.co.jp>
BuildRequires: python python-devel
Requires: libxml2
Requires: readline
Requires: ncurses
Requires: dnsmasq
Requires: bridge-utils
Requires: iptables
# So remote clients can access libvirt over SSH tunnel
# (client invokes 'nc' against the UNIX socket on the server)
Requires: nc
Requires: cyrus-sasl
# Not technically required, but makes 'out-of-box' config
# work correctly & doesn't have onerous dependencies
Requires: cyrus-sasl-md5
%if %{with_polkit}
Requires: PolicyKit >= 0.6
%endif
# For mount/umount in FS driver
BuildRequires: util-linux
%if %{with_qemu}
# From QEMU RPMs
Requires: /usr/bin/qemu-img
%else
%if %{with_xen}
# From Xen RPMs
Requires: /usr/sbin/qcow-create
%endif
%endif
# For LVM drivers
Requires: lvm2
# For ISCSI driver
Requires: iscsi-initiator-utils
# For disk driver
Requires: parted
Requires: /usr/bin/certtool

%if %{with_xen}
BuildRequires: xen-devel
%endif
BuildRequires: libxml2-devel
BuildRequires: readline-devel
BuildRequires: ncurses-devel
BuildRequires: gettext
BuildRequires: gnutls-devel
BuildRequires: avahi-devel
BuildRequires: libselinux-devel
BuildRequires: dnsmasq
BuildRequires: bridge-utils
%if %{with_qemu}
BuildRequires: qemu
%endif
BuildRequires: cyrus-sasl-devel
%if %{with_polkit}
BuildRequires: PolicyKit-devel >= 0.6
%endif
# For mount/umount in FS driver
BuildRequires: util-linux
#%if %{with_qemu}
## From QEMU RPMs
#BuildRequires: /usr/bin/qemu-img
#%else
#%if %{with_xen}
## From Xen RPMs
#BuildRequires: /usr/sbin/qcow-create
#%endif
#%endif
# For LVM drivers
BuildRequires: lvm2
# For ISCSI driver
BuildRequires: iscsi-initiator-utils
# For disk driver
BuildRequires: parted-devel

# Fedora build root suckage
BuildRequires: gawk

%description
Libvirt is a C toolkit to interact with the virtualization capabilities
of recent versions of Linux (and other OSes).

%package devel
Summary: Libraries, includes, etc. to compile with the libvirt library
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: pkgconfig
%if %{with_xen}
Requires: xen-devel
%endif

%description devel
Includes and documentations for the C library providing an API to use
the virtualization capabilities of recent versions of Linux (and other OSes).

%package python
Summary: Python bindings for the libvirt library
Group: Development/Libraries
Requires: %{name} = %{version}

%description python
The libvirt-python package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the libvirt library to use the virtualization capabilities
of recent versions of Linux (and other OSes).

%prep
%setup -q -n %{_target}-%{version}

#%patch100 -p1 -b .graphic-xpath
#%patch101 -p1 -b .dbus-1
%patch110 -p1 -b .no_ipv6_support
%patch200 -p1 -b .vendor_xm_config_dir
%patch201 -p1 -b .hde_dir

%build
%if ! %{with_xen}
%define _without_xen --without-xen
%endif

%if ! %{with_qemu}
%define _without_qemu --without-qemu
%endif

%configure %{?_without_xen} \
           %{?_without_qemu} \
%if %{rhel5}
           --with-rhel5-api \
%endif
%if %{debug}
           --enable-debug=yes \
%endif
           --enable-iptables-lokkit=no \
           --prefix=%{_prefix} \
           --localstatedir=%{_localstatedir} \
           --with-init-script=redhat \

#           --with-qemud-pid-file=%{_localstatedir}/run/%{name}_qemud.pid \
#           --with-remote-file=%{_localstatedir}/run/%{name}d.pid

make PYTHON_SITE_PACKAGES=%{python_sitelib} pythondir=%{python_sitelib}

%install
rm -fr %{buildroot}

make install DESTDIR=$RPM_BUILD_ROOT pythondir=%{python_sitelib}

(cd docs/examples ; make clean ; rm -rf .deps Makefile Makefile.in)
(cd docs/examples/python ; rm -f Makefile Makefile.in)
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/*.a
rm -f $RPM_BUILD_ROOT%{python_sitelib}/*.la
rm -f $RPM_BUILD_ROOT%{python_sitelib}/*.a
install -d -m 0755 $RPM_BUILD_ROOT%{_localstatedir}/run/%{name}/

# Default dir for disk images defined in SELinux policy
install -d -m 0755 $RPM_BUILD_ROOT%{_libvirt_datadir}/images/
# Default dir for kernel+initrd images defnied in SELinux policy
install -d -m 0755 $RPM_BUILD_ROOT%{_libvirt_datadir}/boot/

# We don't want to install /etc/libvirt/qemu/networks in the main %files list
# because if the admin wants to delete the default network completely, we don't
# want to end up re-incarnating it on every RPM upgrade.
install -d -m 0755 $RPM_BUILD_ROOT%{_datadir}/libvirt/networks/
cp $RPM_BUILD_ROOT%{_sysconfdir}/libvirt/qemu/networks/default.xml \
   $RPM_BUILD_ROOT%{_datadir}/libvirt/networks/default.xml
rm -f $RPM_BUILD_ROOT%{_sysconfdir}/libvirt/qemu/networks/default.xml
rm -f $RPM_BUILD_ROOT%{_sysconfdir}/libvirt/qemu/networks/autostart/default.xml
# Strip auto-generated UUID - we need it generated per-install
sed -i -e "/<uuid>/d" $RPM_BUILD_ROOT%{_datadir}/libvirt/networks/default.xml
%find_lang %{_target}

rm -rf $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/
rm -rf $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/

rm -f $RPM_BUILD_ROOT/etc/rc.d/init.d/libvirtd
install -d -m 0755 $RPM_BUILD_ROOT/etc/rc.d/init.d/
cp -f %SOURCE102 $RPM_BUILD_ROOT/etc/rc.d/init.d/%{_vendor_name}-libvirtd
chmod +x $RPM_BUILD_ROOT/etc/rc.d/init.d/%{_vendor_name}-libvirtd

install -d -m 0755 $RPM_BUILD_ROOT/etc/sysconfig/
cp -f %SOURCE100 $RPM_BUILD_ROOT/etc/sysconfig/%{_vendor_name}-libvirtd
cp -f %SOURCE101 $RPM_BUILD_ROOT%{_sysconfdir}/libvirt/libvirtd.conf

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/pki/CA/
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/pki/libvirt/private/
cp -f %SOURCE200 $RPM_BUILD_ROOT%{_sysconfdir}/pki

install -d -m 0755 $RPM_BUILD_ROOT/var/log/%{name}/qemu/

install -d -m 0755 $RPM_BUILD_ROOT/etc/logrotate.d/
if [ -f $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/libvirtd ]; then
  sed -e "s#/var/log/libvirt#/var/log/%{name}#" $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/libvirtd >$RPM_BUILD_ROOT/etc/logrotate.d/%{_vendor_name}-libvirtd
fi
rm -rf $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/

# unpackaged file(s)
rm -rf $RPM_BUILD_ROOT%{_libexecdir}/libvirt_parthelper

%clean
rm -fr %{buildroot}

%pre

%post
/sbin/ldconfig

# We want to install the default network for initial RPM installs
# or on the first upgrade from a non-network aware libvirt only.
# We check this by looking to see if the daemon is already installed
/sbin/chkconfig --list %{_vendor_name}-libvirtd 1>/dev/null 2>&1
if [ $? != 0 ]
then
    UUID=`/usr/bin/uuidgen`
    sed -e "s,</name>,</name>\n  <uuid>$UUID</uuid>," \
         < %{_datadir}/libvirt/networks/default.xml \
         > %{_sysconfdir}/libvirt/qemu/networks/default.xml
    if [ ! -e %{_sysconfdir}/libvirt/qemu/networks/autostart/default.xml ]; then
      ln -s ../default.xml %{_sysconfdir}/libvirt/qemu/networks/autostart/default.xml
    fi
fi

/sbin/chkconfig --add %{_vendor_name}-libvirtd

%preun
if [ $1 = 0 ]; then
    /sbin/service %{_vendor_name}-libvirtd stop 1>/dev/null 2>&1
    /sbin/chkconfig --del %{_vendor_name}-libvirtd
fi

%postun
/sbin/ldconfig

%files -f %{_target}.lang
%defattr(-, root, root)

%doc AUTHORS ChangeLog NEWS README COPYING.LIB TODO
%{_mandir}/man1/*.1*
%{_bindir}/*
%{_libdir}/lib*.so.*
%dir %attr(0770, root, root) %{_sysconfdir}/libvirt/
%dir %attr(0770, root, root) %{_sysconfdir}/libvirt/qemu/
%dir %attr(0770, root, root) %{_sysconfdir}/libvirt/qemu/networks/
%dir %attr(0770, root, root) %{_sysconfdir}/libvirt/qemu/networks/autostart
/etc/rc.d/init.d/%{_vendor_name}-libvirtd
%config(noreplace) /etc/sysconfig/%{_vendor_name}-libvirtd
%config(noreplace) %{_sysconfdir}/libvirt/libvirtd.conf
%config(noreplace) %{_sysconfdir}/libvirt/qemu.conf
%config(noreplace) %{_sysconfdir}/sasl2/libvirt.conf
%dir %{_datadir}/libvirt/
%dir %{_datadir}/libvirt/networks/
%{_datadir}/libvirt/networks/default.xml
%dir %{_localstatedir}/run/%{name}/
%dir %{_libvirt_datadir}/
%dir %attr(0770, root, root) %{_libvirt_datadir}/images/
%dir %attr(0770, root, root) %{_libvirt_datadir}/boot/
%if %{with_polkit}
%{_datadir}/PolicyKit/policy/libvirtd.policy
%endif
#%dir %attr(0700, root, root) %{_localstatedir}/log/%{name}/qemu/
%if %{with_xen_proxy}
%attr(4755, root, root) %{_libexecdir}/libvirt_proxy
%endif
%{_libexecdir}/libvirt_lxc
#%attr(0755, root, root) %{_libexecdir}/libvirt_parthelper
%attr(0755, root, root) %{_sbindir}/libvirtd
#%doc docs/*.rng
%doc docs/*.xml
%{_defaultdocdir}
%{_datadir}/augeas/lenses/*
%dir %{_sysconfdir}/pki/CA/
%dir %{_sysconfdir}/pki/libvirt/private/
%attr(0755, root, root) %{_sysconfdir}/pki/*.sh
%dir /var/log/%{name}/qemu/
%{_datadir}/libvirt/schemas/*
/etc/logrotate.d/*

%files devel
%defattr(-, root, root)

%{_libdir}/lib*.so
%dir %{_includedir}/libvirt
%{_includedir}/libvirt/*.h
%{_libdir}/pkgconfig/libvirt.pc
%doc %{_datadir}/gtk-doc/html/libvirt/*.devhelp
%doc %{_datadir}/gtk-doc/html/libvirt/*.html
%doc %{_datadir}/gtk-doc/html/libvirt/*.png
%doc %{_datadir}/gtk-doc/html/libvirt/*.css

%doc docs/*.html docs/html docs/*.gif
%doc docs/examples
%doc docs/libvirt-api.xml

%files python
%defattr(-, root, root)

%doc AUTHORS NEWS README COPYING.LIB
%{python_sitelib}/libvirt.py*
%{python_sitelib}/libvirtmod*
%doc python/tests/*.py
%doc python/TODO
%doc python/libvirtclass.txt
%doc docs/examples/python

%changelog
* Tue Sep 1 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.7.0-1
- New upstream release.

* Mon Aug 31 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.6.5-2
- Change libvirt-0.6.5-hde_dir.patch. fixed dom autostart link bugs.

* Tue Jul 8 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.6.5-1
- Update version 0.6.5.
- Apply libvirt-0.6.5-hde_dir.patch
- Remove libvirt-0.6.1-xenpriv.patch

* Tue Jun 2 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.6.4-1
- Update version 0.6.4.

* Tue May 19 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.6.3-3
- disabled qemu.

* Tue May 19 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.6.3-2
- Apply libvirt-0.6.3-hde_dir.patch

* Mon Apr 27 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.3-1
- Update version 0.6.3.

* Tue Apr 7 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.2-1
- Update version 0.6.2.
- Removed libvirt-0.6.1-qemu_event.patch

* Thu Mar 27 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.1-5
- Changed priority of startup order in sysv init script. 97 => 98

* Tue Mar 17 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.1-4
- Removed libvirt-0.6.1-max_clients.patch
- Added new parameter in libvirtd.conf
- Apply libvirt-0.6.1-qemu_event.patch (temporary patch)

* Tue Mar 17 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.1-3
- Apply libvirt-0.6.1-max_clients.patch

* Fri Mar 6 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.1-2
- Apply libvirt-0.6.1-xenpriv.patch

* Thu Mar 5 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.1-1
- Update version 0.6.1

* Thu Feb 19 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.0-3
- append configure option --enable-debug=yes

* Fri Feb 13 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.0-2
- append configure option --with-rhel5-api

* Fri Feb 13 2009 HDE Package Maintainer <info@hde.co.jp> - 0.6.0-1
- Update version 0.6.0

* Tue Feb 3 2009 HDE Package Maintainer <info@hde.co.jp> - 0.5.1-4
- image data area was moved.

* Thu Jan 22 2009 HDE Package Maintainer <info@hde.co.jp> - 0.5.1-3
- follow FHS.

* Thu Dec 11 2008 HDE Package Maintainer <info@hde.co.jp> - 0.5.1-2
- Add 'Requires: /usr/bin/certtool'

* Fri Dec 5 2008 HDE Package Maintainer <info@hde.co.jp> - 0.5.1-1
- Update version 0.5.1

* Thu Nov 27 2008 HDE Package Maintainer <info@hde.co.jp> - 0.5.0-1
- Update version 0.5.0

* Thu Nov 13 2008 HDE Package Maintainer <info@hde.co.jp> - 0.4.6-2
- Apply libvirt-0.4.6-vendor_xm_config_dir.patch

* Fri Sep 26 2008 HDE Package Maintainer <info@hde.co.jp> - 0.4.6-1
- Update version 0.4.6

* Wed Sep 10 2008 HDE Package Maintainer <info@hde.co.jp> - 0.4.5-1
- release of 0.4.5
