%define _target		lighttpd
%define _vendor_name	hde
%define _name		%{_vendor_name}-%{_target}
%define _with_ssl	1

%define _prefix		/opt/%{_vendor_name}
%define _mandir		%{_prefix}/share/man
%define _defaultdocdir	%{_prefix}/share/doc
%define _documentroot	%{_prefix}/www
%define _logdir		/var/log/%{_name}
%define _sysconfdir	/etc%{_prefix}
%define _rundir		%{_var}/run/%{_name}
%define _libdir		%{_prefix}/lib/lighttpd

%define _user		wwwhde
%define _group		wwwhde
%define _user_doc	HDE Web Server
%define _uid_min	200
%define _uid_max	300

Summary: A fast webserver with minimal memory-footprint (lighttpd)
Name: %{_name}
Version: 1.4.22
Release: 2
Source: http://www.lighttpd.net/download/lighttpd-%version.tar.gz
Source10: http://redmine.lighttpd.net/attachments/366/mod_fdajax-0.9.tgz
Source100: rc.lighttpd.redhat
Source101: lighttpd.conf.default
Source102: server.pem
Packager: Taizo ITO <taizo.ito@hde.co.jp>
License: BSD
Group: Networking/Daemons
URL: http://www.lighttpd.net/
Vendor: HDE,Inc.
Requires: pcre >= 3.1 zlib
BuildRequires: /usr/bin/pcre-config
BuildRequires: libtool zlib-devel
%if %{_with_ssl}
Requires: hde-openssl098
BuildRequires: hde-openssl098-devel
%endif
BuildRoot: %{_tmppath}/%{name}-root

%description
lighttpd is intented to be a frontend for ad-servers which have to deliver
small files concurrently to many connections.

Available rpmbuild rebuild options:
--with: ssl mysql lua memcache

%prep
%setup -q -n %{_target}-%{version}

tar -zxvf %{SOURCE10}
cp -f mod_fdajax-0.9/src/* src/
cat <<_EOT_>>src/Makefile.am

lib_LTLIBRARIES += mod_fdajax.la
mod_fdajax_la_SOURCES = mod_fdajax.c mod_fdajax_parser.c mod_fdajax_peercall.c mod_fdajax_info.c mod_fdajax_users.c mod_fdajax_alerts.c mod_fdajax_chat.c mod_fdajax_messages.c mod_fdajax_windows.c mod_fdajax_groups.c mod_fdajax_events.c
mod_fdajax_la_LDFLAGS = -module -export-dynamic -avoid-version -no-undefined
mod_fdajax_la_LIBADD = \$(common_libadd)

_EOT_
autoreconf -fi

%build
rm -rf %{buildroot}
%configure \
    --prefix=%{_prefix} \
    --libdir=%{_libdir} \
    --mandir=%{_mandir} \
    --without-bzip2 \
    %{?_with_mysql:       --with-mysql} \
    %{?_with_lua:         --with-lua} \
    %{?_with_memcache:    --with-memcache} \
    %{?_with_ssl:         --with-openssl=/usr/local/hde} \
    %{?_with_ssl:         --with-openssl-includes=/usr/local/hde/include} \
    %{?_with_ssl:         --with-openssl-libs=/usr/local/hde/lib} \

#    --docdir=%{_docdir} \

LD_RUN_PATH=/usr/local/hde/lib make

%install
%makeinstall

mkdir -p %{buildroot}/etc/{init.d,sysconfig}
if [ -f /etc/redhat-release -o -f /etc/fedora-release ]; then
	install -m 755 %{SOURCE100} %{buildroot}/etc/init.d/%{_name}
else
	install -m 755 doc/rc.lighttpd %{buildroot}/etc/init.d/%{_name}
fi
#install -m 644 doc/sysconfig.lighttpd %{buildroot}/etc/sysconfig/%{_name}
mkdir -p %{buildroot}%{_sysconfdir}/lighttpd/ssl
install -m 644 %{SOURCE101} %{buildroot}%{_sysconfdir}/lighttpd/lighttpd.conf
install -m 644 %{SOURCE102} %{buildroot}%{_sysconfdir}/lighttpd/ssl/

mkdir -p %{buildroot}%{_documentroot}
mkdir -p %{buildroot}%{_logdir}
mkdir -p %{buildroot}%{_rundir}

mkdir -p %{buildroot}%{_sysconfdir}/lighttpd/conf.d/

%clean
rm -rf %{buildroot}

%pre
# Add group
getent group | %{__grep} "^%{_group}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent group | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _gid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/groupadd -g ${_gid} -f %{_group}
fi

# Add user
getent passwd | %{__grep} "^%{_user}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent passwd | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _uid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/useradd -c "%{_user_doc}" -u ${_uid} -g %{_group} -s /bin/false -r -d %{_documentroot} %{_user} 2> /dev/null || :
fi

%post
## read http://www.fedora.us/docs/spec.html next time :)
if [ "$1" = "1" ]; then
	# real install, not upgrade
	/sbin/chkconfig --add %{name}
fi



%preun
if [ "$1" = "0" ]; then
	# real uninstall, not upgrade
	/etc/init.d/%{name} stop
	/sbin/chkconfig --del %{name}

	/usr/sbin/userdel %{_user} 2>/dev/null || :
	/usr/sbin/groupdel %{_group} 2>/dev/null || :
fi

%files
%defattr(-,root,root)
%doc doc/lighttpd.conf doc/lighttpd.user README INSTALL ChangeLog COPYING AUTHORS
%doc doc/*.txt
%config(noreplace) %attr(0755,root,root) /etc/init.d/%{_name}
#%config(noreplace) %attr(0644,root,root) /etc/sysconfig/%{_name}
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/lighttpd/lighttpd.conf
%config(noreplace) %attr(0400,root,root) %{_sysconfdir}/lighttpd/ssl/server.pem
%dir %{_sysconfdir}/lighttpd/conf.d/
%{_mandir}/*
%{_libdir}/*
%{_sbindir}/*
%{_bindir}/*
%defattr(-,%{_user},%{_group})
%dir %{_documentroot}
%dir %{_logdir}
%dir %{_rundir}

%changelog
* Tue May 19 2009 Taizo ITO <taizo.ito@hde.co.jp> - 1.4.22-2
- added default settings for tuning performance.

* Mon Mar 9 2009 HDE Package Maintainer <info@hde.co.jp> - 1.4.22-1
- update version

* Tue Feb 17 2009 HDE Package Maintainer <info@hde.co.jp> - 1.4.21-1
- update version

* Thu Jan 22 2009 HDE Package Maintainer <info@hde.co.jp> - 1.4.20-5
- follow FHS.

* Fri Jan 16 2009 HDE Package Maintainer <info@hde.co.jp> - 1.4.20-4
- appended conf.d/ directory.

* Wed Dec 3 2008 HDE Package Maintainer <info@hde.co.jp> - 1.4.20-3
- fixed useradd/groupadd routine in %pre script

* Fri Oct 24 2008 HDE Package Maintainer <info@hde.co.jp> - 1.4.20-1
- update version

* Fri Aug 1 2008 HDE Package Maintainer <info@hde.co.jp> - 1.4.19-1
- initial version
