%define vendor_name hde

%define target_name pysqlite
%define version 2.5.5
%define major_version %(echo %{version} | cut -c1-3)
%define unmangled_version 2.5.5
%define release 1

%define _prefix /opt/%{vendor_name}

%define python_sitearch  %{_prefix}/lib/python


Summary: DB-API 2.0 interface for SQLite 3.x
Name: %{vendor_name}-python-%{target_name}
Version: %{version}
Release: %{release}
Source0: http://oss.itsystementwicklung.de/download/pysqlite/%{major_version}/%{unmangled_version}/%{target_name}-%{unmangled_version}.tar.gz
License: zlib/libpng
Group: Development/Languages
Vendor: HDE,Inc.
URL: http://pysqlite.org/
Packager: Taizo ITO <taizo.ito@hde.co.jp>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildRequires: sqlite-devel
Requires: sqlite

%description
pysqlite is an interface to the SQLite 3.x embedded relational database
engine. It is almost fully compliant with the Python database API version
2.0 also exposes the unique features of SQLite.

%prep
%setup -n %{target_name}-%{unmangled_version}

#sed -e 's#"pysqlite2.test"##' setup.py >setup.py.$$
#cp -f setup.py.$$ setup.py
#rm -f setup.py.$$

grep -v 'py25tests' pysqlite2/test/__init__.py | \
grep -v 'sys\.version_info' >pysqlite2/test/__init__.py.$$
cp -f pysqlite2/test/__init__.py.$$ pysqlite2/test/__init__.py
rm -f pysqlite2/test/__init__.py.$$
rm -f pysqlite2/test/py25tests*

%build
python setup.py build

%install
python setup.py install --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES --home=%{_prefix} --install-lib %{python_sitearch}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f INSTALLED_FILES
%defattr(-,root,root)

%changelog
* Tue May 19 2009 Taizo ITO <taizo.ito@hde.co.jp> - 2.5.5-1
- Update version 2.5.5

* Fri Jan 23 2009 HDE Package Maintainer <info@hde.co.jp> - 2.5.1-2
- changed installed directory 'unix_prefix' => 'unix_home'.

* Tue Jan 20 2009 HDE Package Maintainer <info@hde.co.jp> - 2.5.1-1
- initial
