#!/bin/sh

_sysconfdir=/etc/opt/hde
_pkidir=${_sysconfdir}/pki

__sed=/bin/sed
__mkdir=/bin/mkdir
__mkdir_p="${__mkdir} -p"

___which() {
  if [ "x$1" = "x" ]; then
    return 1
  fi
  search_paths=/sbin:/bin:${_bindir}:${_sbin_dir}:${_hde_bindir}:$PATH
  for apath in `echo ${search_paths} | ${__sed} -e "s/:/ /g"`
  do
    if [ -x ${apath}/$1 ]; then
      echo ${apath}/$1
      return 0
    fi
  done
  return 1
}
__certtool=`___which certtool`

if [ "x${__certtool}" = "x" ]; then
  echo "ERROR: 'certtool' not found" >&2
  exit 1
fi

organization=HDE
fqdn=`hostname -f`

if [ ! -e ${_pkidir} ]; then
  ${__mkdir_p} ${_pkidir}/{CA,libvirt/private}
fi


# Setting up a Certificate Authority (CA)
${__certtool} --generate-privkey >${_pkidir}/CA/cakey.pem
cat <<__EOF__ >${_pkidir}/CA/ca.info
cn = ${fqdn}
ca
cert_signing_key
__EOF__
${__certtool} --generate-self-signed --load-privkey ${_pkidir}/CA/cakey.pem --template ${_pkidir}/CA/ca.info --outfile ${_pkidir}/CA/cacert.pem 

# Issuing server certificates
${__certtool} --generate-privkey >${_pkidir}/libvirt/private/serverkey.pem
cat <<__EOF__ >${_pkidir}/libvirt/server.info
organization = ${organization}
cn = ${fqdn}
tls_www_server
encryption_key
signing_key
__EOF__
${__certtool} --generate-certificate --load-privkey ${_pkidir}/libvirt/private/serverkey.pem --load-ca-certificate ${_pkidir}/CA/cacert.pem --load-ca-privkey ${_pkidir}/CA/cakey.pem --template ${_pkidir}/libvirt/server.info --outfile ${_pkidir}/libvirt/servercert.pem

# Issuing client certificates
${__certtool} --generate-privkey > ${_pkidir}/libvirt/private/clientkey.pem 
cat <<__EOF__ >${_pkidir}/libvirt/client.info
country = JP
state = Tokyo
locality = Tokyo
organization = ${organization}
cn = ${fqdn}
tls_www_client
encryption_key
signing_key
__EOF__
${__certtool} --generate-certificate --load-privkey ${_pkidir}/libvirt/private/clientkey.pem  --load-ca-certificate ${_pkidir}/CA/cacert.pem --load-ca-privkey ${_pkidir}/CA/cakey.pem   --template ${_pkidir}/libvirt/client.info --outfile ${_pkidir}/libvirt/clientcert.pem

exit 0
