/*
Kasumi: Dictionary management tool for Anthy
Copyright (C) 2004 Takashi Nakamoto

This file is part of Kasumi

Kasumi is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Please send bug-reports, opinions and patches, if any, to me by E-Mail.
My E-mail address is following: bluedwarf@openoffice.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include "intl.h"
#include "addwindow.h"
#include "eucjp.h"
#include "anthy_dic.h"
#include "io.h"

GtkWidget *add_word_entry,*add_yomi_entry,*add_freq_spin;
GtkCombo *add_part_combo;

static gboolean delete_event(GtkWidget *widget,
                             GdkEvent *event,
                             gpointer data)
{
  save_anthy_dic();  
  return FALSE;
}

static void destroy(GtkWidget *widget, gpointer data){
  save_anthy_dic();
  gtk_main_quit();
}

static void quit(GtkWidget *widget, gpointer data){
  if(!delete_event(widget,NULL,data)){
    gtk_main_quit();
  }
}

static void add(GtkWidget *widget, gpointer gdata){
  AnthyWord newword;
  char *part;

  newword.word = gtk_editable_get_chars(GTK_EDITABLE(add_word_entry),0,-1);
  newword.yomi = gtk_editable_get_chars(GTK_EDITABLE(add_yomi_entry),0,-1);
  newword.freq = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(add_freq_spin));
  part = gtk_editable_get_chars(GTK_EDITABLE(add_part_combo->entry),0,-1);
  if(strcmp(part,UTF8_MEISHI) == 0){
    newword.part = NOUN;
  }else if(strcmp(part,UTF8_FUKUSHI) == 0){
    newword.part = ADVERB;
  }else if(strcmp(part,UTF8_JINNMEI) == 0){
    newword.part = PERSON;
  }else if(strcmp(part,UTF8_CHIMEI) == 0){
    newword.part = PLACE;
  }else if(strcmp(part,UTF8_KEIYOUSHI) == 0){
    newword.part = ADJECTIVE;
  }
  free(part);
  newword.noun_na_connection = NO;
  newword.noun_sa_connection = NO;
  newword.noun_suru_connection = NO;
  newword.noun_gokan = NO;
  newword.noun_kakujoshi_connection = NO;
  newword.adv_to_connection = NO;
  newword.adv_taru_connection = NO;
  newword.adv_suru_connection = NO;
  newword.adv_gokan = NO;

  add_word(newword);
}

static void clear(GtkWidget *widget, gpointer data){
  printf("Clear\n");
}

int create_add_window()
{
  GtkWidget *window;
  GtkWidget *vbox,*alignment,*label,*hbutton_box,*button;
  GtkObject *adjustment;
  GList *items = NULL;  

  /* set up window */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), _("Kasumi - adding word"));
  g_signal_connect(G_OBJECT(window), "delete_event",
                   G_CALLBACK(delete_event), NULL);
  g_signal_connect(G_OBJECT(window), "destroy",
                   G_CALLBACK(destroy), NULL);

  /* creating add window's vbox */
  vbox = gtk_vbox_new(FALSE,8);
  gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
  gtk_container_add(GTK_CONTAINER(window),vbox);

  /* creating text entries for "Word" */
  label = gtk_label_new(_("Word"));
  alignment = gtk_alignment_new(0,0.5,0,0);
  gtk_container_add(GTK_CONTAINER(alignment),GTK_WIDGET(label));
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(alignment),FALSE,FALSE,0);

  add_word_entry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(add_word_entry),FALSE,FALSE,0);

  /* creating text entries for "Yomi" */
  label = gtk_label_new(_("Yomi"));
  alignment = gtk_alignment_new(0,0.5,0,0);
  gtk_container_add(GTK_CONTAINER(alignment),GTK_WIDGET(label));
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(alignment),FALSE,FALSE,0);

  add_yomi_entry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(add_yomi_entry),FALSE,FALSE,0);

  /* creating spin button for "Frequency" */
  label = gtk_label_new(_("Frequency"));
  alignment = gtk_alignment_new(0,0.5,0,0);
  gtk_container_add(GTK_CONTAINER(alignment),GTK_WIDGET(label));
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(alignment),FALSE,FALSE,0);

  adjustment = gtk_adjustment_new(1,1,32767,1,100,0);
  add_freq_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adjustment),1.0,0);
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(add_freq_spin),FALSE,FALSE,0);

  /* creating combo box for "Part of Speech" */
  label = gtk_label_new(_("Part of Speech"));
  alignment = gtk_alignment_new(0,0.5,0,0);
  gtk_container_add(GTK_CONTAINER(alignment),GTK_WIDGET(label));
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(alignment),FALSE,FALSE,0);

  add_part_combo = GTK_COMBO(gtk_combo_new());
  items = g_list_append(items,_("Noun"));
  items = g_list_append(items,_("Adverb"));
  items = g_list_append(items,_("Person's name"));
  items = g_list_append(items,_("Place-name"));
  items = g_list_append(items,_("Adjective"));
  gtk_combo_set_popdown_strings(GTK_COMBO(add_part_combo), items);
  gtk_entry_set_editable(GTK_ENTRY(add_part_combo->entry),FALSE);
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(add_part_combo),FALSE,FALSE,0);

  /* creating box for buttons */
  hbutton_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbutton_box),GTK_BUTTONBOX_SPREAD);
  gtk_box_pack_start(GTK_BOX(vbox),GTK_WIDGET(hbutton_box),FALSE,FALSE,0);

  /* creating buttons */
  button = gtk_button_new();
  gtk_button_set_label(GTK_BUTTON(button),_("Add"));
  gtk_box_pack_start(GTK_BOX(hbutton_box),GTK_WIDGET(button),FALSE,FALSE,0);
  g_signal_connect(G_OBJECT(button),"clicked",
                   G_CALLBACK(add),NULL);

  button = gtk_button_new();
  gtk_button_set_label(GTK_BUTTON(button),_("Clear"));
  gtk_box_pack_start(GTK_BOX(hbutton_box),GTK_WIDGET(button),FALSE,FALSE,0);
  g_signal_connect(G_OBJECT(button),"clicked",
                   G_CALLBACK(clear),NULL);

  button = gtk_button_new();
  gtk_button_set_label(GTK_BUTTON(button),_("Quit"));
  gtk_box_pack_start(GTK_BOX(hbutton_box),GTK_WIDGET(button),FALSE,FALSE,0);
  g_signal_connect(G_OBJECT(button),"clicked",
                   G_CALLBACK(quit),NULL);

  gtk_widget_show_all(window);

  return 1;
}
