/*
Kasumi: Dictionary management tool for Anthy
Copyright (C) 2004 Takashi Nakamoto

This file is part of Kasumi

Kasumi is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Please send bug-reports, opinions and patches, if any, to me by E-Mail.
My E-mail address is following: bluedwarf@openoffice.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"
#include "io.h"

#define BUF_SIZE 256

char *read_data_from_dic(){
  FILE *fp;
  char buf[BUF_SIZE];
  char *contents, *tmp;
  int i = 0;
  int read_size;
  
  fp = fopen(dic_filename, "rb");

  /* if cannot find private-dic.src, ... */
  if(fp == NULL){
    contents = (char *)malloc(1);
    *contents = '\0';
    return contents;
  }
  
  contents = (char *)malloc(0);
  
  do{
    read_size = fread(buf, 1, BUF_SIZE, fp);
    i++;

    tmp = contents;
    contents = (char *)malloc(BUF_SIZE*i);
    copy_buffer(contents, tmp, BUF_SIZE*(i-1));
    add_buffer(contents, buf, read_size, BUF_SIZE*(i-1));
  }while(read_size == BUF_SIZE);
  contents[BUF_SIZE*(i-1) + read_size] = 0;
  
  fclose(fp);

  return contents;
}

void write_data_to_dic(const char *data){
  FILE *fp;
  char buf[BUF_SIZE];
  static char *command = NULL;
  int i = 0;
  int read_size;

  fp = fopen(dic_filename, "w");

  fputs(data,fp);
  
  fclose(fp);

  /* register words */
  if(command == NULL){
    command = (char *)calloc(strlen("cat  | anthy-dic-tool --load") +
                             strlen(dic_filename) + 1, sizeof(char));
    sprintf(command,"cat %s | anthy-dic-tool --load",dic_filename);
  }

  if(system(command) == 0){
     g_printf("correctly registered dictionary\n");
  }else{
     g_printf("cannot register dicitionary for some reason\n");
    exit(1);
  }
}

int copy_buffer(char *buf1, const char *buf2, int size)
{
  int i;

  for(i=0; i<size; i++){
    buf1[i] = buf2[i];
  }

  return 0;
}

int add_buffer(char *buf1, const char *buf2, int size, int start_pos)
{
  int i;

  for(i=0;i<size;i++){
    buf1[start_pos + i] = buf2[i];
  }

  return 0;
}

